<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("2.4. Submitting an Example Workflow");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="tutorial.php">Tutorial</a></span> &gt; <span class="breadcrumb-node">Submitting an Example Workflow</span>
</div><hr><div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="tutorial_submitting_wf"></a>2.4. Submitting an Example Workflow</h2></div></div></div>
<p>All of the example workflows described in the previous section can
    be generated with the <code class="literal">pegasus-init</code> command. For this
    tutorial we will be using the split workflow, which can be created like
    this:</p>
<pre class="programlisting">$ <span class="bold"><strong>cd /home/tutorial</strong></span>
$ <span class="bold"><strong>pegasus-init split</strong></span>
Do you want to generate a tutorial workflow? (y/n) [n]: <span class="bold"><strong>y</strong></span>
1: Process
2: Pipeline
3: Split
4: Merge
5: Diamond
What tutorial workflow do you want? (1-5) [1]: <span class="bold"><strong>3</strong></span>
$ <span class="bold"><strong>cd split</strong></span>
$ <span class="bold"><strong>ls</strong></span>
README.md          input              plan_dax.sh        tc.txt
daxgen.py          output             rc.txt
generate_dax.sh    pegasus.properties sites.xml
</pre>
<div class="tip" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Tip</h3>
<p>The <code class="literal">pegasus-init</code> tool can be used to generate
      workflow skeletons from templates by asking the user questions. It is
      easier to use pegasus-init than to start a new workflow from
      scratch.</p>
</div>
<p>The split workflow looks like this:</p>
<div class="figure">
<a name="idm207"></a><p class="title"><b>Figure 2.6. Split Workflow</b></p>
<div class="figure-contents"><div class="mediaobject" align="center"><img src="images/tutorial-split-wf.jpg" align="middle" width="378" alt="Split Workflow"></div></div>
</div>
<br class="figure-break"><p>The input workflow description for Pegasus is called the DAX. It can
    be generated by running the <code class="filename">generate_dax.sh</code> script
    from the split directory, like this:</p>
<pre class="programlisting">$ <span class="bold"><strong>./generate_dax.sh split.dax</strong></span>
Generated dax split.dax
    </pre>
<p>This script will run a small Python program
    (<code class="filename">daxgen.py</code>) that generates a file with a .dax
    extension using the Pegasus Python API. We will cover the details of
    creating a DAX programmatically <a class="link" href="tutorial_wf_generation.php" title="2.8. Generating the Workflow">later in the tutorial</a>. Pegasus
    reads the DAX and generates an executable HTCondor workflow that is run on
    an execution site.</p>
<p>The <code class="literal">pegasus-plan</code> command is used to submit the
    workflow through Pegasus. The pegasus-plan command reads the input
    workflow (DAX file specified by --dax option), maps the abstract DAX to
    one or more execution sites, and submits the generated executable workflow
    to HTCondor. Among other things, the options to pegasus-plan tell
    Pegasus</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; ">
<li class="listitem"><p>the workflow to run</p></li>
<li class="listitem"><p>where (what site) to run the workflow</p></li>
<li class="listitem"><p>the input directory where the inputs are placed</p></li>
<li class="listitem"><p>the output directory where the outputs are placed</p></li>
</ul></div>
<p>By default, the workflow is setup to run on the compute sites (i.e
    sites with handle other than "local") defined in the sites.xml file. In
    our example, the workflow will run on a site named "condorpool" in the
    sites.xml file.</p>
<div class="note" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Note</h3>
<p>If there are multiple compute sites specified in your sites.xml,
      and you want to choose a specific site, use the --sites option to
      pegasus-plan</p>
</div>
<p>To plan the split workflow invoke the pegasus-plan command using the
    <code class="filename">plan_dax.sh</code> wrapper script as follows:</p>
<pre class="programlisting">$ <span class="bold"><strong>./plan_dax.sh split.dax</strong></span>
2015.10.22 19:12:10.402 PDT:
2015.10.22 19:12:10.409 PDT:   -----------------------------------------------------------------------
2015.10.22 19:12:10.414 PDT:   File for submitting this DAG to Condor           : split-0.dag.condor.sub
2015.10.22 19:12:10.420 PDT:   Log of DAGMan debugging messages                 : split-0.dag.dagman.out
2015.10.22 19:12:10.426 PDT:   Log of Condor library output                     : split-0.dag.lib.out
2015.10.22 19:12:10.431 PDT:   Log of Condor library error messages             : split-0.dag.lib.err
2015.10.22 19:12:10.436 PDT:   Log of the life of condor_dagman itself          : split-0.dag.dagman.log
2015.10.22 19:12:10.442 PDT:
2015.10.22 19:12:10.458 PDT:   -----------------------------------------------------------------------
2015.10.22 19:12:14.292 PDT:   Your database is compatible with Pegasus version: 4.5.3
2015.10.22 19:12:15.198 PDT:   Submitting to condor split-0.dag.condor.sub
2015.10.22 19:12:15.997 PDT:   Submitting job(s).
2015.10.22 19:12:16.003 PDT:   1 job(s) submitted to cluster 111.
2015.10.22 19:12:16.035 PDT:
2015.10.22 19:12:16.055 PDT:   Your workflow has been started and is running in the base directory:
2015.10.22 19:12:16.061 PDT:
2015.10.22 19:12:16.071 PDT:     /home/tutorial/split/submit/tutorial/pegasus/split/run0001
2015.10.22 19:12:16.078 PDT:
2015.10.22 19:12:16.084 PDT:   *** To monitor the workflow you can run ***
2015.10.22 19:12:16.090 PDT:
2015.10.22 19:12:16.098 PDT:     pegasus-status -l /home/tutorial/split/submit/tutorial/pegasus/split/run0001
2015.10.22 19:12:16.114 PDT:
2015.10.22 19:12:16.119 PDT:   *** To remove your workflow run ***
2015.10.22 19:12:16.125 PDT:
2015.10.22 19:12:16.131 PDT:     pegasus-remove /home/tutorial/split/submit/tutorial/pegasus/split/run0001
2015.10.22 19:12:16.137 PDT:
2015.10.22 19:12:17.630 PDT:   Time taken to execute is 1.918 seconds</pre>
<div class="note" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Note</h3>
<p>The line in the output that starts with
      <code class="literal">pegasus-status</code>, contains the command you can use to
      monitor the status of the workflow. The path it contains is the path to
      the submit directory where all of the files required to submit and
      monitor the workflow are stored.</p>
</div>
<p>This is what the split workflow looks like after Pegasus has
    finished planning the DAX:</p>
<div class="figure">
<a name="idm241"></a><p class="title"><b>Figure 2.7. Split DAG</b></p>
<div class="figure-contents"><div class="mediaobject"><img src="images/tutorial-split-dag.jpg" alt="Split DAG"></div></div>
</div>
<br class="figure-break"><p>For this workflow the only jobs Pegasus needs to add are a directory
    creation job, a stage-in job (for pegasus.html), and stage-out jobs (for
    wc count outputs). The cleanup jobs remove data that is no longer required
    as workflow executes.</p>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="tutorial_scientific_workflows.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="tutorial.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="tutorial_wf_dashboard.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">2.3. What are Scientific Workflows </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 2.5. Workflow Dashboard for Monitoring and Debugging</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
