<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("Chapter 18. Useful Tips");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-node">Useful Tips</span>
</div><hr><div lang="" class="chapter">
<div class="titlepage"><div><div><h1 class="title">
<a name="useful_tips"></a>Chapter 18. Useful Tips</h1></div></div></div>
<div class="toc"><dl class="toc">
<dt><span class="section"><a href="useful_tips.php#migrating_from_lt47">18.1. Migrating From Pegasus 4.5.X to Pegasus current version</a></span></dt>
<dt><span class="section"><a href="migrating_from_leq44.php">18.2. Migrating From Pegasus &lt;4.5 to Pegasus 4.5.X</a></span></dt>
<dt><span class="section"><a href="migrating_from_3x.php">18.3. Migrating From Pegasus 3.1 to Pegasus 4.X</a></span></dt>
<dt><span class="section"><a href="migrating_from_2x.php">18.4. Migrating From Pegasus 2.X to Pegasus 3.X</a></span></dt>
<dt><span class="section"><a href="portable_code.php">18.5. Best Practices For Developing Portable Code</a></span></dt>
<dt><span class="section"><a href="cpu_affinity_condor.php">18.6. Slot Partitioning and CPU Affinity in Condor</a></span></dt>
</dl></div>
<div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="migrating_from_lt47"></a>18.1. Migrating From Pegasus 4.5.X to Pegasus current version</h2></div></div></div>
<div class="toc"><dl class="toc">
<dt><span class="section"><a href="useful_tips.php#idm18082">18.1.1. Database Upgrades From Pegasus 4.5.X to Pegasus current
      version</a></span></dt>
<dt><span class="section"><a href="useful_tips.php#idm18094">18.1.2. Migration from Pegasus 4.6 to 4.7</a></span></dt>
</dl></div>
<p>Most of the migrations from one version to another are related to
    database upgrades, that is addressed by running the tool <span class="bold"><strong>pegasus-db-admin</strong></span>. </p>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="idm18082"></a>18.1.1. Database Upgrades From Pegasus 4.5.X to Pegasus current
      version</h3></div></div></div>
<p>Since Pegasus 4.5 all databases are managed by a single tool:
      <span class="bold"><strong>pegasus-db-admin</strong></span>. Databases will be
      automatically updated when <span class="bold"><strong>pegasus-plan</strong></span>
      is invoked, but WORKFLOW databases from past runs may not be updated
      accordingly. Since Pegasus 4.6.0, the <span class="bold"><strong>pegasus-db-admin</strong></span> tool provides an option to
      automatically update all databases from completed workflows in the
      MASTER database. To enable this option, run the following
      command:</p>
<pre class="programlisting">
$ pegasus-db-admin update -a
Your database has been updated.
Your database is compatible with Pegasus version: 4.7.0

Verifying and updating workflow databases:
21/21

Summary:
Verified/Updated: 21/21
Failed: 0/21
Unable to connect: 0/21
Unable to update (active workflows): 0/21

Log files:
20161006T134415-dbadmin.out (Succeeded operations)
20161006T134415-dbadmin.err (Failed operations)
      </pre>
<p>This option generates a log file for succeeded operations, and a
      log file for failed operations. Each file contains the list of URLs of
      the succeeded/failed databases.</p>
<p>Note that, if no URL is provided, the tool will create/use a
      SQLite database in the user's home directory:
      <span class="emphasis"><em>${HOME}/.pegasus/workflow.db</em></span>.</p>
<p>For complete description of pegasus-db-admin, see the <a class="link" href="cli-pegasus-db-admin.php" title="pegasus-db-admin">man page</a>.</p>
</div>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="idm18094"></a>18.1.2. Migration from Pegasus 4.6 to 4.7</h3></div></div></div>
<p>In addition to the database changes, in Pegasus 4.7 the default
      submit directory layout was changed from a flat structure where all
      submit files independent of the number of jobs in the workflow appeared
      in a single directory. For 4.7, the default is a hierarchal directory
      structure two levels deep. To use the earlier layout, set the following
      property </p>
<pre class="programlisting">pegasus.dir.submit.mapper     Flat</pre>
</div>
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-version.php">Prev</a> </td>
<td width="20%" align="center"> </td>
<td width="40%" align="right"> <a accesskey="n" href="migrating_from_leq44.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-version </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 18.2. Migrating From Pegasus &lt;4.5 to Pegasus 4.5.X</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
