<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("7.9. Remote PBS Cluster using BOSCO and SSH");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="execution_environments.php">Execution Environments</a></span> &gt; <span class="breadcrumb-node">Remote PBS Cluster using BOSCO and SSH</span>
</div><hr><div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="bosco"></a>7.9. Remote PBS Cluster using BOSCO and SSH</h2></div></div></div>
<p><a class="ulink" href="http://bosco.opensciencegrid.org/about/" target="_top">BOSCO</a>
    enables HTCondor to submit jobs to remote PBS clusters using SSH. This
    section describes how to specify a site catalog entry for a site that has
    been configured for BOSCO job submissions.</p>
<p>First, the site needs to be setup for BOSCO according to the <a class="ulink" href="https://twiki.opensciencegrid.org/bin/view/CampusGrids/BoSCO" target="_top"> BOSCO
    documentation</a>. BOSCO uses glite to submit jobs to the PBS
    scheduler on the remote cluster. You will also need to configure the glite
    installed for BOSCO on the remote system according to the documentation in
    the <a class="link" href="glite.php" title="7.7. Local PBS Cluster Using Glite">glite section</a> in order for the mapping of
    Pegasus profiles to PBS job requirements to work. In particular, you will
    need to install the <code class="literal">pbs_local_submit_attributes.sh</code> and
    <code class="literal">sge_local_submit_attributes.sh</code> scripts in the correct
    place in the glite <code class="literal">bin</code> directory on the remote cluster,
    usually in the directory <span class="emphasis"><em>~/bosco/glite/bin/</em></span> .</p>
<p>Second, to tag a site for SSH submission, the following profiles
    need to be specified for the site in the site catalog:</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p><span class="bold"><strong>pegasus</strong></span> profile <span class="bold"><strong>style</strong></span> with value set to <span class="bold"><strong>ssh</strong></span></p></li>
<li class="listitem"><p>Specify the service information as grid gateways. This should
        match what BOSCO provided when the cluster was set up.</p></li>
</ol></div>
<p>An example site catalog entry for a BOSCO site looks like
    this:</p>
<pre class="programlisting">
&lt;sitecatalog xmlns="http://pegasus.isi.edu/schema/sitecatalog"
             xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
             xsi:schemaLocation="http://pegasus.isi.edu/schema/sitecatalog http://pegasus.isi.edu/schema/sc-4.0.xsd"
             version="4.0"&gt;

    &lt;site  handle="USC_HPCC_Bosco" arch="x86_64" os="LINUX"&gt;

        &lt;!-- Specify the service information. This should match what Bosco provided when the cluster
             was set up. --&gt;
        &lt;grid type="batch" contact="vahi@hpc-pegasus.usc.edu" scheduler="PBS" jobtype="compute"/&gt;
        &lt;grid type="batch" contact="vahi@hpc-pegasus.usc.edu" scheduler="PBS" jobtype="auxillary"/&gt;

        &lt;!-- Scratch directory on the cluster --&gt;
        &lt;directory type="shared-scratch" path="/home/rcf-40/vahi/tmp"&gt;
            &lt;file-server operation="all" url="scp://vahi@hpc-pegasus.usc.edu/home/rcf-40/vahi/tmp"/&gt;
        &lt;/directory&gt;

        &lt;!-- SSH is the style to use for Bosco SSH submits --&gt;
        &lt;profile namespace="pegasus" key="style"&gt;ssh&lt;/profile&gt;

        &lt;!--  works around bug in the HTCondor GAHP, that does not
              set the remote directory --&gt;
        &lt;profile namespace="pegasus" key="change.dir"&gt;true&lt;/profile&gt;

        &lt;!-- Job requirements should be specified using Pegasus profiles --&gt;
        &lt;profile namespace="pegasus" key="queue"&gt;default&lt;/profile&gt;
        &lt;profile namespace="pegasus" key="runtime"&gt;30&lt;/profile&gt;

    &lt;/site&gt;


&lt;/sitecatalog&gt;

</pre>
<div class="note" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Note</h3>
<p>It is recommended to have a submit node configured either as a
      BOSCO submit node or a vanilla HTCondor node. You cannot have HTCondor
      configured both as a BOSCO install and a traditional HTCondor submit
      node at the same time as BOSCO will override the traditional HTCondor
      pool in the user environment.</p>
</div>
<p>There is a bosco-shared-fs example in the examples directory of the
    distribution.</p>
<p>Job Requirements for the jobs can be set using the same profiles as
    listed <a class="link" href="glite.php#glite_mappings" title="7.7.1. Setting job requirements">here</a> .</p>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="bosco_sdsc.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="execution_environments.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="campus_cluster.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">7.8. SDSC Comet with BOSCO glideins </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 7.10. Campus Cluster</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
