<?php  
            require('/srv/new-pegasus.isi.edu/includes/common.php'); 
            pegasus_header("13.2. Profiles");
        ?><div class="breadcrumbs">
<span class="breadcrumb-link"><a href="index.php">Pegasus 4.8.0 User Guide</a></span> &gt; <span class="breadcrumb-link"><a href="configuration.php">Configuration</a></span> &gt; <span class="breadcrumb-node">Profiles</span>
</div><hr><div class="section">
<div class="titlepage"><div><div><h2 class="title" style="clear: both">
<a name="profiles"></a>13.2. Profiles</h2></div></div></div>
<div class="toc"><dl class="toc">
<dt><span class="section"><a href="profiles.php#idm5758">13.2.1. Profile Structure Heading</a></span></dt>
<dt><span class="section"><a href="profiles.php#idm5762">13.2.2. Sources for Profiles</a></span></dt>
<dt><span class="section"><a href="profiles.php#idm5812">13.2.3. Profiles Conflict Resolution</a></span></dt>
<dt><span class="section"><a href="profiles.php#idm5825">13.2.4. Details of Profile Handling</a></span></dt>
<dt><span class="section"><a href="profiles.php#env_profiles">13.2.5. The Env Profile Namespace</a></span></dt>
<dt><span class="section"><a href="profiles.php#idm5900">13.2.6. The Globus Profile Namespace</a></span></dt>
<dt><span class="section"><a href="profiles.php#condor_profiles">13.2.7. The Condor Profile Namespace</a></span></dt>
<dt><span class="section"><a href="profiles.php#dagman_profiles">13.2.8. The Dagman Profile Namespace</a></span></dt>
<dt><span class="section"><a href="profiles.php#pegasus_profiles">13.2.9. The Pegasus Profile Namespace</a></span></dt>
<dt><span class="section"><a href="profiles.php#hints_profiles">13.2.10. The Hints Profile Namespace</a></span></dt>
</dl></div>
<p></p>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="idm5758"></a>13.2.1. Profile Structure Heading</h3></div></div></div>
<p>All profiles are triples comprised of a namespace, a name or key,
      and a value. The namespace is a simple identifier. The key has only
      meaning within its namespace, and it's yet another identifier. There are
      no constraints on the contents of a value</p>
<p>Profiles may be represented with different syntaxes in different
      context. However, each syntax will describe the underlying
      triple.</p>
</div>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="idm5762"></a>13.2.2. Sources for Profiles</h3></div></div></div>
<p>Profiles may enter the job-processing stream at various stages.
      Depending on the requirements and scope a profile is to apply, profiles
      can be associated at</p>
<div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; ">
<li class="listitem"><p>as user property settings.</p></li>
<li class="listitem"><p>dax level</p></li>
<li class="listitem"><p>in the site catalog</p></li>
<li class="listitem"><p>in the transformation catalog</p></li>
</ul></div>
<p>Unfortunately, a different syntax applies to each level and
      context. This section shows the different profile sources and syntaxes.
      However, at the foundation of each profile lies the triple of namespace,
      key and value.</p>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm5775"></a>13.2.2.1. User Profiles in Properties</h4></div></div></div>
<p>Users can specify all profiles in the properties files where the
        property name is <span class="bold"><strong>[namespace].key</strong></span> and
        <span class="bold"><strong>value</strong></span> of the property is the value of
        the profile.</p>
<p>Namespace can be env|condor|globus|dagman|pegasus</p>
<p>Any profile specified as a property applies to the whole
        workflow i.e (all jobs in the workflow) unless overridden at the DAX
        level , Site Catalog , Transformation Catalog Level.</p>
<p>Some profiles that they can be set in the properties file are
        listed below</p>
<pre class="programlisting">env.JAVA_HOME "/software/bin/java"

condor.periodic_release 5
condor.periodic_remove  my_own_expression
condor.stream_error true
condor.stream_output fa

globus.maxwalltime  1000
globus.maxtime      900
globus.maxcputime   10
globus.project      test_project
globus.queue        main_queue

dagman.post.arguments --test arguments
dagman.retry  4
dagman.post simple_exitcode
dagman.post.path.simple_exitcode  /bin/exitcode/exitcode.sh
dagman.post.scope all
dagman.maxpre  12
dagman.priority 13

dagman.bigjobs.maxjobs 1


pegasus.clusters.size 5

pegasus.stagein.clusters 3</pre>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm5784"></a>13.2.2.2. Profiles in DAX</h4></div></div></div>
<p>The user can associate profiles with logical transformations in
        DAX. Environment settings required by a job's application, or a
        maximum estimate on the run-time are examples for profiles at this
        stage.</p>
<pre class="programlisting">&lt;job id="ID000001" namespace="asdf" name="preprocess" version="1.0"
 level="3" dv-namespace="voeckler" dv-name="top" dv-version="1.0"&gt;
  &lt;argument&gt;-a top -T10  -i &lt;filename file="voeckler.f.a"/&gt;
 -o &lt;filename file="voeckler.f.b1"/&gt;
 &lt;filename file="voeckler.f.b2"/&gt;&lt;/argument&gt;
  <span class="bold"><strong>&lt;profile namespace="pegasus" key="walltime"&gt;2&lt;/profile&gt;
  &lt;profile namespace="pegasus" key="diskspace"&gt;1&lt;/profile&gt;</strong></span>
  &amp;mldr;
&lt;/job&gt;
</pre>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm5789"></a>13.2.2.3. Profiles in Site Catalog</h4></div></div></div>
<p>If it becomes necessary to limit the scope of a profile to a
        single site, these profiles should go into the site catalog. A profile
        in the site catalog applies to all jobs and all application run at the
        site. Commonly, site catalog profiles set environment settings like
        the LD_LIBRARY_PATH, or globus rsl parameters like queue and project
        names.</p>
<p>Currently, there is no tool to manipulate the site catalog, e.g.
        by adding profiles. Modifying the site catalog requires that you load
        it into your editor.</p>
<p>The XML version of the site catalog uses the following
        syntax:</p>
<pre class="programlisting"><span class="bold"><strong>&lt;profile namespace=</strong></span>"<span class="emphasis"><em>namespace</em></span>" <span class="bold"><strong>key=</strong></span>"<span class="emphasis"><em>key</em></span>"&gt;<span class="emphasis"><em>value</em></span><span class="bold"><strong>&lt;/profile&gt;</strong></span></pre>
<pre class="programlisting">&lt;site  handle="CCG" arch="x86_64" os="LINUX"&gt;
     &lt;grid  type="gt5" contact="obelix.isi.edu/jobmanager-fork" scheduler="Fork" jobtype="auxillary"/&gt;
        
     &lt;directory type="shared-scratch" path="/shared-scratch"&gt;
            &lt;file-server operation="all" url="gsiftp://headnode.isi.edu/shared-scratch"/&gt;
     &lt;/directory&gt;
     &lt;directory type="local-storage" path="/local-storage"&gt;
            &lt;file-server operation="all" url="gsiftp://headnode.isi.edu/local-storage"/&gt;
     &lt;/directory&gt; 
     &lt;profile namespace="pegasus" key="clusters.num"&gt;1&lt;/profile&gt;
     &lt;profile namespace="env" key="PEGASUS_HOME"&gt;/usr&lt;/profile&gt;        
&lt;/site&gt;
</pre>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm5802"></a>13.2.2.4. Profiles in Transformation Catalog</h4></div></div></div>
<p>Some profiles require a narrower scope than the site catalog
        offers. Some profiles only apply to certain applications on certain
        sites, or change with each application and site.
        Transformation-specific and CPU-specific environment variables, or job
        clustering profiles are good candidates. Such profiles are best
        specified in the transformation catalog.</p>
<p>Profiles associate with a physical transformation and site in
        the transformation catalog. The Database version of the transformation
        catalog also permits the convenience of connecting a transformation
        with a profile.</p>
<p>The Pegasus tc-client tool is a convenient helper to associate
        profiles with transformation catalog entries. As benefit, the user
        does not have to worry about formats of profiles in the various
        transformation catalog instances.</p>
<pre class="programlisting">tc-client -a -P -E -p /home/shared/executables/analyze -t INSTALLED -r isi_condor -e env::GLOBUS_LOCATION=&amp;rdquor;/home/shared/globus&amp;rdquor;</pre>
<p>The above example adds an environment variable GLOBUS_LOCATION
        to the application /home/shared/executables/analyze on site
        isi_condor. The transformation catalog guide has more details on the
        usage of the tc-client.</p>
<pre class="programlisting">tr example::keg:1.0 { 

#specify profiles that apply for all the sites for the transformation 
#in each site entry the profile can be overriden 

  profile env "APP_HOME" "/tmp/myscratch"
  profile env "JAVA_HOME" "/opt/java/1.6"

  site isi {
    <span class="bold"><strong>profile env "HELLo" "WORLD"
    profile condor "FOO" "bar"
    profile env "JAVA_HOME" "/bin/java.1.6"</strong></span>
    pfn "/path/to/keg"
    arch "x86"
    os "linux"
    osrelease "fc"
    osversion "4"
    type "INSTALLED"
  }

  site wind {
    profile env "CPATH" "/usr/cpath"
    profile condor "universe" "condor"
    pfn "file:///path/to/keg"
    arch "x86"
    os "linux"
    osrelease "fc"
    osversion "4"
    type "STAGEABLE"
  }
}</pre>
<p>Most of the users prefer to edit the transformation catalog file
        directly in the editor.</p>
</div>
</div>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="idm5812"></a>13.2.3. Profiles Conflict Resolution</h3></div></div></div>
<p>Irrespective of where the profiles are specified, eventually the
      profiles are associated with jobs. Multiple sources may specify the same
      profile for the same job. For instance, DAX may specify an environment
      variable X. The site catalog may also specify an environment variable X
      for the chosen site. The transformation catalog may specify an
      environment variable X for the chosen site and application. When the job
      is concretized, these three conflicts need to be resolved.</p>
<p>Pegasus defines a priority ordering of profiles. The higher
      priority takes precedence (overwrites) a profile of a lower
      priority.</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p>Transformation Catalog Profiles</p></li>
<li class="listitem"><p>Site Catalog Profiles</p></li>
<li class="listitem"><p>DAX Profiles</p></li>
<li class="listitem"><p>Profiles in Properties</p></li>
</ol></div>
</div>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="idm5825"></a>13.2.4. Details of Profile Handling</h3></div></div></div>
<p>The previous sections omitted some of the finer details for the
      sake of clarity. To understand some of the constraints that Pegasus
      imposes, it is required to look at the way profiles affect jobs.</p>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm5828"></a>13.2.4.1. Details of env Profiles</h4></div></div></div>
<p>Profiles in the env namespace are translated to a
        semicolon-separated list of key-value pairs. The list becomes the
        argument for the Condor environment command in the job's submit
        file.</p>
<pre class="programlisting">######################################################################
# Pegasus WMS  SUBMIT FILE GENERATOR
# DAG : black-diamond, Index = 0, Count = 1
# SUBMIT FILE NAME : findrange_ID000002.sub
######################################################################
globusrsl = (jobtype=single)
<span class="bold"><strong>environment=GLOBUS_LOCATION=/shared/globus;LD_LIBRARY_PATH=/shared/globus/lib;</strong></span>
executable = /shared/software/linux/pegasus/default/bin/kickstart
globusscheduler = columbus.isi.edu/jobmanager-condor
remote_initialdir = /shared/CONDOR/workdir/isi_hourglass
universe = globus
&amp;mldr;
queue
######################################################################
# END OF SUBMIT FILE
</pre>
<p>Condor-G, in turn, will translate the
        <span class="emphasis"><em>environment</em></span> command for any remote job into
        Globus RSL environment settings, and append them to any existing RSL
        syntax it generates. To permit proper mixing, all
        <span class="emphasis"><em>environment</em></span> setting should solely use the env
        profiles, and none of the Condor nor Globus environment
        settings.</p>
<p>If <span class="emphasis"><em>kickstart</em></span> starts a job, it may make use
        of environment variables in its executable and arguments
        setting.</p>
</div>
<div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="idm5838"></a>13.2.4.2. Details of globus Profiles</h4></div></div></div>
<p>Profiles in the <span class="emphasis"><em>globus</em></span> Namespaces are
        translated into a list of paranthesis-enclosed equal-separated
        key-value pairs. The list becomes the value for the Condor
        <span class="emphasis"><em>globusrsl</em></span> setting in the job's submit
        file:</p>
<pre class="programlisting">######################################################################
# Pegasus WMS SUBMIT FILE GENERATOR
# DAG : black-diamond, Index = 0, Count = 1
# SUBMIT FILE NAME : findrange_ID000002.sub
######################################################################
<span class="bold"><strong>globusrsl = (jobtype=single)(queue=fast)(project=nvo)</strong></span>
executable = /shared/software/linux/pegasus/default/bin/kickstart
globusscheduler = columbus.isi.edu/jobmanager-condor
remote_initialdir = /shared/CONDOR/workdir/isi_hourglass
universe = globus
&amp;mldr;
queue
######################################################################
# END OF SUBMIT FILE
</pre>
<p>For this reason, Pegasus prohibits the use of the
        <span class="emphasis"><em>globusrsl</em></span> key in the <span class="emphasis"><em>condor</em></span>
        profile namespace.</p>
</div>
</div>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="env_profiles"></a>13.2.5. The Env Profile Namespace</h3></div></div></div>
<p>The <span class="emphasis"><em>env</em></span> namespace allows users to specify
      environment variables of remote jobs. Globus transports the environment
      variables, and ensure that they are set before the job starts.</p>
<p>The key used in conjunction with an <span class="emphasis"><em>env</em></span>
      profile denotes the name of the environment variable. The value of the
      profile becomes the value of the remote environment variable.</p>
<p>Grid jobs usually only set a minimum of environment variables by
      virtue of Globus. You cannot compare the environment variables visible
      from an interactive login with those visible to a grid job. Thus, it
      often becomes necessary to set environment variables like
      LD_LIBRARY_PATH for remote jobs.</p>
<p>If you use any of the Pegasus worker package tools like transfer
      or the rc-client, it becomes necessary to set PEGASUS_HOME and
      GLOBUS_LOCATION even for jobs that run locally</p>
<div class="table">
<a name="idm5856"></a><p class="title"><b>Table 13.1. Useful Environment Settings</b></p>
<div class="table-contents"><table class="table" summary="Useful Environment Settings" border="1">
<colgroup>
<col>
<col>
</colgroup>
<tbody>
<tr>
<td><span class="bold"><strong>Key Attributes </strong></span></td>
<td><span class="bold"><strong>Description</strong></span></td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>env.PEGASUS_HOME<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>PEGASUS_HOME<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String<br>
</p></div></td>
<td>Used by auxillary jobs created by Pegasus both on remote
              site and local site. Should be set usually set in the Site
              Catalog for the sites</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>env.GLOBUS_LOCATION<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>GLOBUS_LOCATION<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>Used by auxillary jobs created by Pegasus both on remote
              site and local site. Should be set usually set in the Site
              Catalog for the sites</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>env.LD_LIBRARY_PATH<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>LD_LIBRARY_PATH<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>Point this to $GLOBUS_LOCATION/lib, except you cannot use
              the dollar variable. You must use the full path. Applies to
              both, local and remote jobs that use Globus components and
              should be usually set in the site catalog for the sites</td>
</tr>
</tbody>
</table></div>
</div>
<br class="table-break"><p>Even though Condor and Globus both permit environment variable
      settings through their profiles, all remote environment variables must
      be set through the means of <span class="emphasis"><em>env</em></span> profiles.</p>
</div>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="idm5900"></a>13.2.6. The Globus Profile Namespace</h3></div></div></div>
<p>The <span class="emphasis"><em>globus</em></span> profile namespace encapsulates
      Globus resource specification language (RSL) instructions. The RSL
      configures settings and behavior of the remote scheduling system. Some
      systems require queue name to schedule jobs, a project name for
      accounting purposes, or a run-time estimate to schedule jobs. The Globus
      RSL addresses all these issues.</p>
<p>A key in the <span class="emphasis"><em>globus</em></span> namespace denotes the
      command name of an RSL instruction. The profile value becomes the RSL
      value. Even though Globus RSL is typically shown using parentheses
      around the instruction, the out pair of parentheses is not necessary in
      globus profile specifications</p>
<p>The table below shows some commonly used RSL instructions. For an
      authoritative list of all possible RSL instructions refer to the Globus
      RSL specification.</p>
<div class="table">
<a name="idm5907"></a><p class="title"><b>Table 13.2. Useful Globus RSL Instructions</b></p>
<div class="table-contents"><table class="table" summary="Useful Globus RSL Instructions" border="1">
<colgroup>
<col>
<col>
</colgroup>
<tbody>
<tr>
<td><span class="bold"><strong>Property Key </strong></span></td>
<td><span class="bold"><strong>Description</strong></span></td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>globus.count<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>count<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>Integer</p></div></td>
<td>the number of times an executable is started.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>globus.jobtype<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>jobtype<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>specifies how the job manager should start the remote
              job. While Pegasus defaults to single, use mpi when running MPI
              jobs.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>globus.maxcputime<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>maxcputime<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>Integer</p></div></td>
<td>the max CPU time in minutes for a single execution of a
              job.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>globus.maxmemory<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>maxmemory<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>Integer</p></div></td>
<td>the maximum memory in MB required for the job</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>globus.maxtime<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>maxtime<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>Integer</p></div></td>
<td>the maximum time or walltime in minutes for a single
              execution of a job.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>globus.maxwalltime<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>maxwalltime<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>Integer</p></div></td>
<td>the maximum walltime in minutes for a single execution of
              a job.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>globus.minmemory<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>minmemory<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>Integer</p></div></td>
<td>the minumum amount of memory required for this
              job</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>globus.project<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>project<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>associates an account with a job at the remote
              end.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>globus.queue<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>queue<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>the remote queue in which the job should be run. Used
              when remote scheduler is PBS that supports queues.</td>
</tr>
</tbody>
</table></div>
</div>
<br class="table-break"><p>Pegasus prevents the user from specifying certain RSL instructions
      as globus profiles, because they are either automatically generated or
      can be overridden through some different means. For instance, if you
      need to specify remote environment settings, do not use the environment
      key in the globus profiles. Use one or more env profiles instead.</p>
<div class="table">
<a name="idm6016"></a><p class="title"><b>Table 13.3. RSL Instructions that are not permissible</b></p>
<div class="table-contents"><table class="table" summary="RSL Instructions that are not permissible" border="1">
<colgroup>
<col>
<col>
</colgroup>
<tbody>
<tr>
<td><span class="bold"><strong>Key</strong></span></td>
<td><span class="bold"><strong>Reason for
              Prohibition</strong></span></td>
</tr>
<tr>
<td>arguments</td>
<td>you specify arguments in the arguments section for a job
              in the DAX</td>
</tr>
<tr>
<td>directory</td>
<td>the site catalog and properties determine which directory
              a job will run in.</td>
</tr>
<tr>
<td>environment</td>
<td>use multiple env profiles instead</td>
</tr>
<tr>
<td>executable</td>
<td>the physical executable to be used is specified in the
              transformation catalog and is also dependant on the gridstart
              module being used. If you are launching jobs via kickstart then
              the executable created is the path to kickstart and the
              application executable path appears in the arguments for
              kickstart</td>
</tr>
<tr>
<td>stdin</td>
<td>you specify in the DAX for the job</td>
</tr>
<tr>
<td>stdout</td>
<td>you specify in the DAX for the job</td>
</tr>
<tr>
<td>stderr</td>
<td>you specify in the DAX for the job</td>
</tr>
</tbody>
</table></div>
</div>
<br class="table-break">
</div>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="condor_profiles"></a>13.2.7. The Condor Profile Namespace</h3></div></div></div>
<p>The Condor submit file controls every detail how and where a job
      is run. The <span class="emphasis"><em>condor</em></span> profiles permit to add or
      overwrite instructions in the Condor submit file.</p>
<p>The <span class="emphasis"><em>condor</em></span> namespace directly sets commands
      in the Condor submit file for a job the profile applies to. Keys in the
      <span class="emphasis"><em>condor</em></span> profile namespace denote the name of the
      Condor command. The profile value becomes the command's argument. All
      <span class="emphasis"><em>condor</em></span> profiles are translated into key=value lines
      in the Condor submit file</p>
<p>Some of the common condor commands that a user may need to specify
      are listed below. For an authoritative list refer to the online condor
      documentation. Note: Pegasus Workflow Planner/Mapper by default specify
      a lot of condor commands in the submit files depending upon the job, and
      where it is being run.</p>
<div class="table">
<a name="idm6055"></a><p class="title"><b>Table 13.4. Useful Condor Commands</b></p>
<div class="table-contents"><table class="table" summary="Useful Condor Commands" border="1">
<colgroup>
<col>
<col>
</colgroup>
<tbody>
<tr>
<td><span class="bold"><strong>Property Key </strong></span></td>
<td><span class="bold"><strong>Description</strong></span></td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>condor.universe<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>universe<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>Pegasus defaults to either globus or scheduler universes.
              Set to standard for compute jobs that require standard universe.
              Set to vanilla to run natively in a condor pool, or to run on
              resources grabbed via condor glidein.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>condor.periodic_release<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>periodic_release<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>is the number of times job is released back to the queue
              if it goes to HOLD, e.g. due to Globus errors. Pegasus defaults
              to 3.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>condor.periodic_remove<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>periodic_remove<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>is the number of times a job is allowed to get into HOLD
              state before being removed from the queue. Pegasus defaults to
              3.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>condor.filesystemdomain<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>filesystemdomain<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>Useful for Condor glide-ins to pin a job to a remote
              site.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>condor.stream_error<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>stream_error <span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>Boolean</p></div></td>
<td>boolean to turn on the streaming of the stderr of the
              remote job back to submit host.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>condor.stream_output<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>stream_output<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>Boolean</p></div></td>
<td>boolean to turn on the streaming of the stdout of the
              remote job back to submit host.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>condor.priority<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>priority<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>integer value to assign the priority of a job. Higher
              value means higher priority. The priorities are only applied for
              vanilla / standard/ local universe jobs. Determines the order in
              which a users own jobs are executed.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>condor.request_cpus<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>request_cpus<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>New in Condor 7.8.0 . Number of CPU's a job
              requires.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>condor.request_gpus<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>request_cpus<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 4.6<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>Number of GPU's a job requires.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>condor.request_memory<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>request_memory<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>New in Condor 7.8.0 . Amount of memory a job
              requires.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>condor.request_disk<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>request_disk<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>New in Condor 7.8.0 . Amount of disk a job
              requires.</td>
</tr>
</tbody>
</table></div>
</div>
<br class="table-break"><p>Other useful condor keys, that advanced users may find useful and
      can be set by profiles are</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p>should_transfer_files</p></li>
<li class="listitem"><p>transfer_output</p></li>
<li class="listitem"><p>transfer_error</p></li>
<li class="listitem"><p>whentotransferoutput</p></li>
<li class="listitem"><p>requirements</p></li>
<li class="listitem"><p>rank</p></li>
</ol></div>
<p>Pegasus prevents the user from specifying certain Condor commands
      in condor profiles, because they are automatically generated or can be
      overridden through some different means. The table below shows
      prohibited Condor commands.</p>
<div class="table">
<a name="idm6200"></a><p class="title"><b>Table 13.5. Condor commands prohibited in condor profiles</b></p>
<div class="table-contents"><table class="table" summary="Condor commands prohibited in condor profiles" border="1">
<colgroup>
<col>
<col>
</colgroup>
<tbody>
<tr>
<td><span class="bold"><strong>Key</strong></span></td>
<td><span class="bold"><strong>Reason for
              Prohibition</strong></span></td>
</tr>
<tr>
<td>arguments</td>
<td>you specify arguments in the arguments section for a job
              in the DAX</td>
</tr>
<tr>
<td>environment</td>
<td>use multiple env profiles instead</td>
</tr>
<tr>
<td>executable</td>
<td>the physical executable to be used is specified in the
              transformation catalog and is also dependant on the gridstart
              module being used. If you are launching jobs via kickstart then
              the executable created is the path to kickstart and the
              application executable path appears in the arguments for
              kickstart</td>
</tr>
</tbody>
</table></div>
</div>
<br class="table-break">
</div>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="dagman_profiles"></a>13.2.8. The Dagman Profile Namespace</h3></div></div></div>
<p>DAGMan is Condor's workflow manager. While planners generate most
      of DAGMan's configuration, it is possible to tweak certain job-related
      characteristics using dagman profiles. A dagman profile can be used to
      specify a DAGMan pre- or post-script.</p>
<p>Pre- and post-scripts execute on the submit machine. Both inherit
      the environment settings from the submit host when pegasus-submit-dag or
      pegasus-run is invoked.</p>
<p>By default, kickstart launches all jobs except standard universe
      and MPI jobs. Kickstart tracks the execution of the job, and returns
      usage statistics for the job. A DAGMan post-script starts the Pegasus
      application exitcode to determine, if the job succeeded. DAGMan receives
      the success indication as exit status from exitcode.</p>
<p>If you need to run your own post-script, you have to take over the
      job success parsing. The planner is set up to pass the file name of the
      remote job's stdout, usually the output from kickstart, as sole argument
      to the post-script.</p>
<p>The table below shows the keys in the dagman profile domain that
      are understood by Pegasus and can be associated at a per job
      basis.</p>
<div class="table">
<a name="idm6226"></a><p class="title"><b>Table 13.6. Useful dagman Commands that can be associated at a per job
          basis</b></p>
<div class="table-contents"><table class="table" summary="Useful dagman Commands that can be associated at a per job
          basis" border="1">
<colgroup>
<col>
<col>
</colgroup>
<tbody>
<tr>
<td><span class="bold"><strong>Property Key </strong></span></td>
<td><span class="bold"><strong>Description</strong></span></td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>dagman.pre<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>PRE<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>is the path to the pre-script. DAGMan executes the
                pre-script before it runs the job.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>dagman.pre.arguments<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>PRE.ARGUMENTS<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>are command-line arguments for the pre-script, if
                any.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>dagman.post<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>POST<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>is the postscript type/mode that a user wants to
                associate with a job. <div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p><span class="bold"><strong>pegasus-exitcode</strong></span>
                      - pegasus will by default associate this postscript with
                      all jobs launched via kickstart, as long the POST.SCOPE
                      value is not set to NONE.</p></li>
<li class="listitem"><p><span class="bold"><strong>none</strong></span> -means that
                      no postscript is generated for the jobs. This is useful
                      for MPI jobs that are not launched via kickstart
                      currently.</p></li>
<li class="listitem">
<p><span class="bold"><strong>any legal
                      identifier</strong></span> - Any other identifier of the form
                      ([_A-Za-z][_A-Za-z0-9]*), than one of the 2 reserved
                      keywords above, signifies a user postscript. This allows
                      the user to specify their own postscript for the jobs in
                      the workflow. The path to the postscript can be
                      specified by the dagman profile <span class="bold"><strong>POST.PATH.[value</strong></span>] where [value]
                      is this legal identifier specified. The user postscript
                      is passed the name of the .out file of the job as the
                      last argument on the command line.</p>
<p>For e.g. if the following dagman profiles were
                      associated with a job X</p>
<div class="orderedlist"><ol class="orderedlist" type="a">
<li class="listitem"><p>POST with value user_script
                          /bin/user_postscript</p></li>
<li class="listitem"><p>POST.PATH.user_script with value
                          /path/to/user/script</p></li>
<li class="listitem"><p>POST.ARGUMENTS with value -verbose</p></li>
</ol></div>
<p>then the following postscript will be associated
                      with the job X in the .dag file</p>
<p>/path/to/user/script -verbose X.out where X.out
                      contains the stdout of the job X</p>
</li>
</ol></div>
</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>dagman.post.path.[value of dagman.post]<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>post.path.[value of dagman.post]<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>the path to the post script on the submit host.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>dagman.post.arguments<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>POST.ARGUMENTS<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>are the command line arguments for the post script, if
                any.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>dagman.retry<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>RETRY<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>Integer<br>
<span class="bold"><strong>Default     :</strong></span> 1</p></div></td>
<td>is the number of times DAGMan retries the full job
                cycle from pre-script through post-script, if failure was
                detected.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>dagman.category<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>CATEGORY<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>the DAGMan category the job belongs to.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>dagman.priority<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>PRIORITY<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>Integer</p></div></td>
<td>the priority to apply to a job. DAGMan uses this to
                select what jobs to release when MAXJOBS is enforced for the
                DAG.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>dagman.abort-dag-on<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>ABORT-DAG-ON <br>
<span class="bold"><strong>Scope       :</strong></span> TC, DAX,<br>
<span class="bold"><strong>Since       :</strong></span> 4.5<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>The ABORT-DAG-ON key word provides a way to abort the
                entire DAG if a given node returns a specific exit code
                (AbortExitValue). The syntax for the value of the key is
                AbortExitValue [RETURN DAGReturnValue] . When a DAG aborts, by
                default it exits with the node return value that caused the
                abort. This can be changed by using the optional RETURN key
                word along with specifying the desired DAGReturnValue</td>
</tr>
</tbody>
</table></div>
</div>
<p><br class="table-break"></p>
<p></p>
<p>The table below shows the keys in the dagman profile domain that
      are understood by Pegasus and can be used to apply to the whole
      workflow. These are used to control DAGMan's behavior at the workflow
      level, and are recommended to be specified in the properties
      file.</p>
<div class="table">
<a name="dagman_throttling_profiles"></a><p class="title"><b>Table 13.7. Useful dagman Commands that can be specified in the properties
        file.</b></p>
<div class="table-contents"><table class="table" summary="Useful dagman Commands that can be specified in the properties
        file." border="1">
<colgroup>
<col>
<col>
</colgroup>
<tbody>
<tr>
<td><span class="bold"><strong>Property Key </strong></span></td>
<td><span class="bold"><strong>Description</strong></span></td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>dagman.maxpre<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>MAXPRE<span class="bold"><strong><br>
Scope       :</strong></span> Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>sets the maximum number of PRE scripts within the DAG
              that may be running at one time</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>dagman.maxpost<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>MAXPOST<span class="bold"><strong><br>
Scope       :</strong></span> Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>sets the maximum number of POST scripts within the DAG
              that may be running at one time</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>dagman.maxjobs<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>MAXJOBS<span class="bold"><strong><br>
Scope       :</strong></span> Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>sets the maximum number of jobs within the DAG that will
              be submitted to Condor at one time.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>dagman.maxidle<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>MAXIDLE<span class="bold"><strong><br>
Scope       :</strong></span> Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>Sets the maximum number of idle jobs allowed before
              HTCondor DAGMan stops submitting more jobs. Once idle jobs start
              to run, HTCondor DAGMan will resume submitting jobs. If the
              option is omitted, the number of idle jobs is unlimited.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>dagman.[CATEGORY-NAME].maxjobs<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>[CATEGORY-NAME].MAXJOBS<span class="bold"><strong><br>
Scope       :</strong></span> Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>is the value of maxjobs for a particular category. Users
              can associate different categories to the jobs at a per job
              basis. However, the value of a dagman knob for a category can
              only be specified at a per workflow basis in the
              properties.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>dagman.post.scope<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>POST.SCOPE<span class="bold"><strong><br>
Scope       :</strong></span> Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>scope for the postscripts. <div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem"><p>If set to <span class="bold"><strong>all</strong></span> ,
                    means each job in the workflow will have a postscript
                    associated with it.</p></li>
<li class="listitem"><p>If set to <span class="bold"><strong>none</strong></span> ,
                    means no job has postscript associated with it. None mode
                    should be used if you are running vanilla / standard/
                    local universe jobs, as in those cases Condor traps the
                    remote exitcode correctly. None scope is not recommended
                    for grid universe jobs.</p></li>
<li class="listitem"><p>If set to <span class="bold"><strong>essential</strong></span>, means only essential
                    jobs have post scripts associated with them. At present
                    the only non essential job is the replica registration
                    job.</p></li>
</ol></div>
</td>
</tr>
</tbody>
</table></div>
</div>
<br class="table-break">
</div>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="pegasus_profiles"></a>13.2.9. The Pegasus Profile Namespace</h3></div></div></div>
<p>The <span class="emphasis"><em>pegasus</em></span> profiles allow users to configure
      extra options to the Pegasus Workflow Planner that can be applied
      selectively to a job or a group of jobs. Site selectors may use a
      sub-set of <span class="emphasis"><em>pegasus</em></span> profiles for their
      decision-making.</p>
<p>The table below shows some of the useful configuration option
      Pegasus understands.</p>
<div class="table">
<a name="idm6449"></a><p class="title"><b>Table 13.8. Useful pegasus Profiles.</b></p>
<div class="table-contents"><table class="table" summary="Useful pegasus Profiles." border="1">
<colgroup>
<col>
<col>
</colgroup>
<tbody>
<tr>
<td><span class="bold"><strong>Property Key </strong></span></td>
<td><span class="bold"><strong>Description</strong></span></td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.clusters.num<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>clusters.num<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 3.0<br>
<span class="bold"><strong>Type        : </strong></span>Integer</p></div></td>
<td>Please refer to the <a class="link" href="job_clustering.php#horizontal_clustering" title="11.2.1.1.1. Horizontal Clustering">Pegasus Clustering Guide</a>
              for detailed description. This option determines the total
              number of clusters per level. Jobs are evenly spread across
              clusters.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.clusters.size<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>clusters.size<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 3.0<br>
<span class="bold"><strong>Type        : </strong></span>Integer</p></div></td>
<td>Please refer to the <a class="link" href="job_clustering.php#horizontal_clustering" title="11.2.1.1.1. Horizontal Clustering">Pegasus Clustering Guide</a>
              for detailed description. This profile determines the number of
              jobs in each cluster. The number of clusters depends on the
              total number of jobs on the level.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.job.aggregator<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>job.aggregator<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>Integer</p></div></td>
<td>Indicates the clustering executable that is used to run
              the clustered job on the remote site.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.gridstart<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>gridstart<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>Determines the executable for launching a job. This
              covers both tasks ( jobs specified by the user in the DAX) and
              additional jobs added by Pegasus during the planning operation.
              Possible values are <span class="bold"><strong><span class="emphasis"><em>Kickstart |
              NoGridStart</em></span></strong></span> | PegasusLite | Distribute at
              the moment. <div class="note" style="margin-left: 0.5in; margin-right: 0.5in;">
<h3 class="title">Note</h3>
<p>This profile should only be set by users if you know
                  what you are doing. Otherwise, let Pegasus do the right
                  thing based on your configuration.</p>
</div>
<div class="variablelist"><dl class="variablelist">
<dt><span class="term">Kickstart</span></dt>
<dd>
                       By default, all jobs executed are launched using a lightweight C executable called pegasus-kickstart. This generates valuable runtime provenance information for the job as it is executed on a remote node. This information serves as the basis for the monitoring and debugging capabilities provided by Pegasus. 
                    </dd>
<dt><span class="term">NoGridStart</span></dt>
<dd>
                       This explicity disables the wrapping of the jobs with pegasus-kickstart. This is internally used by the planner to launch dax jobs directly. If this is set, then the information populated in the monitording database is on the basis of what is recorded in the DAGMan out file. 
                    </dd>
<dt><span class="term">PegasusLite</span></dt>
<dd>
                       This value is automatically associated by the Planner whenever the job runs in either nonsharedfs or condorio mode. The property pegasus.data.configuration decides whether a job is launched via PegasusLite or not. PegasusLite is a lightweight Pegasus wrapper generated for each job that allows a job to run in a nonshared file system environment and is responsible for staging in the input data and staging out the output data back to a remote staging site for the job. 
                    </dd>
<dt><span class="term">Distribute</span></dt>
<dd><p>This wrapper is a HubZero specfiic wrapper that
                      allows compute jobs that are scheduled for a local PBS
                      cluster to be run locally on the submit host. The jobs
                      are wrapped with a distribute wrapper that is
                      responsible for doing the qsub and tracking of the
                      status of the jobs in the PBS cluster.</p></dd>
</dl></div>
</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.gridstart.path<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>gridstart.path<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>file path</p></div></td>
<td>Sets the path to the gridstart . This profile is best set
              in the Site Catalog.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.gridstart.arguments<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>gridstart.arguments<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>Sets the arguments with which GridStart is used to launch
              a job on the remote site.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.stagein.clusters<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>stagein.clusters<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 4.0<br>
<span class="bold"><strong>Type        : </strong></span>Integer</p></div></td>
<td>This key determines the maximum number of
              <span class="emphasis"><em>stage-in</em></span> jobs that are can executed locally
              or remotely per compute site per workflow. This is used to
              configure the <span class="emphasis"><em><a class="link" href="transfer.php#transfer-refiner-balanced-cluster" title="10.2.5.1. BalancedCluster">BalancedCluster</a></em></span>
              Transfer Refiner, which is the Default Refiner used in Pegasus.
              This profile is best set in the Site Catalog or in the
              Properties file</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.stagein.local.clusters<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>stagein.local.clusters<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 4.0<br>
<span class="bold"><strong>Type        : </strong></span>Integer</p></div></td>
<td>This key provides finer grained control in determining
              the number of stage-in jobs that are executed locally and are
              responsible for staging data to a particular remote site. This
              profile is best set in the Site Catalog or in the Properties
              file</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.stagein.remote.clusters<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>stagein.remote.clusters<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 4.0<br>
<span class="bold"><strong>Type        : </strong></span>Integer</p></div></td>
<td>This key provides finer grained control in determining
              the number of stage-in jobs that are executed remotely on the
              remote site and are responsible for staging data to it. This
              profile is best set in the Site Catalog or in the Properties
              file</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.stageout.clusters<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>stageout.clusters<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 4.0<br>
<span class="bold"><strong>Type        : </strong></span>Integer</p></div></td>
<td>This key determines the maximum number of
              <span class="emphasis"><em>stage-out</em></span> jobs that are can executed
              locally or remotely per compute site per workflow. This is used
              to configure the <span class="emphasis"><em><a class="link" href="transfer.php#transfer-refiner-balanced-cluster" title="10.2.5.1. BalancedCluster">BalancedCluster</a></em></span>
              Transfer Refiner, , which is the Default Refiner used in
              Pegasus.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.stageout.local.clusters<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>stageout.local.clusters<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 4.0<br>
<span class="bold"><strong>Type        : </strong></span>Integer</p></div></td>
<td>This key provides finer grained control in determining
              the number of stage-out jobs that are executed locally and are
              responsible for staging data from a particular remote site. This
              profile is best set in the Site Catalog or in the Properties
              file</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.stageout.remote.clusters<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>stageout.remote.clusters<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 4.0<br>
<span class="bold"><strong>Type        : </strong></span>Integer</p></div></td>
<td>This key provides finer grained control in determining
              the number of stage-out jobs that are executed remotely on the
              remote site and are responsible for staging data from it. This
              profile is best set in the Site Catalog or in the Properties
              file</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.group<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>group<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>Tags a job with an arbitrary group identifier. The group
              site selector makes use of the tag.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.change.dir<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>change.dir<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>Boolean</p></div></td>
<td>If true, tells <span class="emphasis"><em>kickstart</em></span> to change
              into the remote working directory. Kickstart itself is executed
              in whichever directory the remote scheduling system chose for
              the job.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.create.dir<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>create.dir<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>Boolean</p></div></td>
<td>If true, tells <span class="emphasis"><em>kickstart</em></span> to create
              the the remote working directory before changing into the remote
              working directory. Kickstart itself is executed in whichever
              directory the remote scheduling system chose for the
              job.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.transfer.proxy<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>transfer.proxy<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>Boolean</p></div></td>
<td>If true, tells Pegasus to explicitly transfer the proxy
              for transfer jobs to the remote site. This is useful, when you
              want to use a full proxy at the remote end, instead of the
              limited proxy that is transferred by CondorG.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.style<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>style<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>Sets the condor submit file style. If set to globus,
              submit file generated refers to CondorG job submissions. If set
              to condor, submit file generated refers to direct Condor
              submission to the local Condor pool. It applies for glidein,
              where nodes from remote grid sites are glided into the local
              condor pool. The default style that is applied is
              globus.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.pmc_request_memory<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>pmc_request_memory<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 4.2<br>
<span class="bold"><strong>Type        : </strong></span>Integer</p></div></td>
<td>This key is used to set the -m option for
              pegasus-mpi-cluster. It specifies the amount of memory in MB
              that a job requires. This profile is usually set in the DAX for
              each job.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.pmc_request_cpus<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>pmc_request_cpus<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 4.2<br>
<span class="bold"><strong>Type        : </strong></span>Integer</p></div></td>
<td>This key is used to set the -c option for
              pegasus-mpi-cluster. It specifies the number of cpu's that a job
              requires. This profile is usually set in the DAX for each
              job.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.pmc_priority<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>pmc_priority<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 4.2<br>
<span class="bold"><strong>Type        : </strong></span>Integer</p></div></td>
<td>This key is used to set the -p option for
              pegasus-mpi-cluster. It specifies the priority for a job . This
              profile is usually set in the DAX for each job. Negative values
              are allowed for priorities.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.pmc_task_arguments<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>pmc_task_arguments<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 4.2<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>The key is used to pass any extra arguments to the PMC
              task during the planning time. They are added to the very end of
              the argument string constructed for the task in the PMC file.
              Hence, allows for overriding of any argument constructed by the
              planner for any particular task in the PMC job.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.exitcode.failuremsg<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>exitcode.failuremsg<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 4.4<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>The message string that pegasus-exitcode searches for in
              the stdout and stderr of the job to flag failures.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.exitcode.successmsg<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>exitcode.successmsg<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 4.4<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>The message string that pegasus-exitcode searches for in
              the stdout and stderr of the job to determine whether a job
              logged it's success message or not. Note this value is used to
              check for whether a job failed or not i.e if this profile is
              specified, and pegasus-exitcode DOES NOT find the string in the
              job stdout or stderr, the job is flagged as failed. The complete
              rules for determining failure are described in the man page for
              pegasus-exitcode.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.checkpoint.time<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>checkpoint_time<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 4.5<br>
<span class="bold"><strong>Type        : </strong></span>Integer</p></div></td>
<td>the expected time in minutes for a job after which it
              should be sent a TERM signal to generate a job checkpoint
              file</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.maxwalltime<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>maxwalltime<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 4.5<br>
<span class="bold"><strong>Type        : </strong></span>Integer</p></div></td>
<td>the maximum walltime in minutes for a single execution of
              a job.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.glite.arguments<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>glite.arguments<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 4.5<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>specifies the extra arguments that must appear in the
              local PBS generated script for a job, when running workflows on
              a local cluster with submissions through Glite. This is useful
              when you want to pass through special options to underlying LRMS
              such as PBS e.g. you can set value -l walltime=01:23:45 -l
              nodes=2 to specify your job's resource requirements.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Profile  Key: </strong></span></strong></span>auxillary.local<span class="bold"><strong><br>
Scope       :</strong></span> SC<br>
<span class="bold"><strong>Since       :</strong></span> 4.6<br>
<span class="bold"><strong>Type        : </strong></span>Boolean</p></div></td>
<td>indicates whether auxillary jobs associated with a
              compute site X, can be run on local site. This CAN ONLY be
              specified as a profile in the site catalog and should be set
              when the compute site filesystem is accessible locally on the
              submit host.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong>Property Key:</strong></span> pegasus.condor.arguments.quote<span class="bold"><strong><br>
Profile  Key: </strong></span>condor.arguments.quote<span class="bold"><strong><br>
Scope       :</strong></span> SC, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 4.6<br>
<span class="bold"><strong>Type        : </strong></span>Boolean</p></div></td>
<td>indicates whether condor quoting rules should be applied
              for writing out the arguments key in the condor submit file. By
              default it is true unless the job is schedule to a glite style
              site. The value is automatically set to false for glite style
              sites, as condor quoting is broken in batch_gahp.</td>
</tr>
</tbody>
</table></div>
</div>
<br class="table-break"><div class="section">
<div class="titlepage"><div><div><h4 class="title">
<a name="task_resource_profiles"></a>13.2.9.1. Task Resource Requirements Profiles</h4></div></div></div>
<p>Startng Pegasus 4.6.0 Release, users can specify pegasus
        profiles to describe resources requirements for their job. The planner
        will automatically translate them to appropriate execution environment
        specific directives. For example, the profiles are automatically
        translated to Globus RSL keys if submitting job via CondorG to remote
        GRAM instances, Condor Classad keys when running in a vanilla condor
        pool and to appropriate shell variables for Glite that can be picked
        up by the local attributes.sh. The profiles are described
        below.</p>
<div class="table">
<a name="idm6795"></a><p class="title"><b>Table 13.9. Task Resource Requirement Profiles.</b></p>
<div class="table-contents"><table class="table" summary="Task Resource Requirement Profiles." border="1">
<colgroup>
<col>
<col>
</colgroup>
<tbody>
<tr>
<td><span class="bold"><strong>Property Key
                  </strong></span></td>
<td><span class="bold"><strong>Description</strong></span></td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.runtime<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>runtime<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 2.0<br>
<span class="bold"><strong>Type        : </strong></span>Long</p></div></td>
<td>This profile specifies the expected runtime of a job
                  in seconds. Refer to the <a class="link" href="job_clustering.php#runtime_clustering" title="11.2.1.1.2. Runtime Clustering">Pegasus Clustering Guide</a>
                  for description on using it for runtime clustering.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>clusters.maxruntime<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>pegasus.clusters.maxruntime<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 4.0<br>
<span class="bold"><strong>Type        : </strong></span>Integer</p></div></td>
<td>Please refer to the <a class="link" href="job_clustering.php#runtime_clustering" title="11.2.1.1.2. Runtime Clustering">Pegasus Clustering Guide</a>
                  for detailed description. This profile specifies the maximum
                  runtime of a job.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.cores<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>cores<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 4.0<br>
<span class="bold"><strong>Type        : </strong></span>Integer</p></div></td>
<td>The total number of cores, required for a job. This
                  is also used for accounting purposes in the database while
                  generating statistics. It corresponds to the
                  multiplier_factor in the job_instance table described <a class="link" href="monitoring.php#stampede_schema_overview" title="6.5.2. Overview of the Workflow Database Schema.">here</a>.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.nodes<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>nodes<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 4.6<br>
<span class="bold"><strong>Type        : </strong></span>Integer</p></div></td>
<td>Indicates the the number of nodes a job
                  requires.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.ppn<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>ppn<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 4.6<br>
<span class="bold"><strong>Type        : </strong></span>Integer</p></div></td>
<td>Indicates the number of processors per node . This
                  profile is best set in the Site Catalog and usually set when
                  running workflows with MPI jobs.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.memory<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>memory<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 4.6<br>
<span class="bold"><strong>Type        : </strong></span>Long</p></div></td>
<td>Indicates the maximum memory a job requires in
                  MB.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>pegasus.diskspace<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>diskspace<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 4.6<br>
<span class="bold"><strong>Type        : </strong></span>Long</p></div></td>
<td>Indicates the maximum diskspace a job requires in
                  MB.</td>
</tr>
</tbody>
</table></div>
</div>
<p><br class="table-break">The automatic translation to various execution environment
        specific directives is explained below. It is important, to note that
        execution environment specific keys take precedence over the Pegasus
        profile keys. For example, Globus profile key maxruntime will be
        preferred over Pegasus profile key runtime when running jobs via
        HTCondorG.</p>
<div class="table">
<a name="idm6884"></a><p class="title"><b>Table 13.10. Table mapping translation of Pegasus Task Requirements to
          corresponding execution environment keys.</b></p>
<div class="table-contents"><table class="table" summary="Table mapping translation of Pegasus Task Requirements to
          corresponding execution environment keys." border="1">
<colgroup>
<col>
<col>
<col>
<col>
</colgroup>
<thead><tr>
<th align="center">Pegasus Task Resource Requirement
                Profile Key</th>
<th align="center">Corresponding Globus RSL Key</th>
<th align="center">Corresponding Condor Classad Key</th>
<th align="center">KEY in +remote_cerequirements classad
                for GLITE</th>
</tr></thead>
<tbody>
<tr>
<td>runtime</td>
<td>maxruntime</td>
<td>-</td>
<td>WALLTIME</td>
</tr>
<tr>
<td>cores</td>
<td>count</td>
<td>request_cpus</td>
<td>CORES</td>
</tr>
<tr>
<td>nodes</td>
<td>hostcount</td>
<td>-</td>
<td>NODES</td>
</tr>
<tr>
<td>ppn</td>
<td>xcount</td>
<td>-</td>
<td>PROCS</td>
</tr>
<tr>
<td>memory</td>
<td>maxmemory</td>
<td>request_memory</td>
<td>PER_PROCESS_MEMORY</td>
</tr>
<tr>
<td>diskspace</td>
<td>-</td>
<td>request_diskspace</td>
<td>-</td>
</tr>
</tbody>
</table></div>
</div>
<br class="table-break">
</div>
</div>
<div class="section">
<div class="titlepage"><div><div><h3 class="title">
<a name="hints_profiles"></a>13.2.10. The Hints Profile Namespace</h3></div></div></div>
<p>The <span class="emphasis"><em>hints</em></span> namespace allows users to override
      the behavior of the Workflow Mapper during site selection. This gives
      you finer grained control over where a job executes and what executable
      it refers to. The hints namespace keys ( execution.site and pfn ) can
      only be specified in the DAX. It is important to note that these
      particular keys once specified in the DAX, cannot be overriden like
      other profiles.</p>
<div class="table">
<a name="idm6928"></a><p class="title"><b>Table 13.11. Useful Hints Profile Keys</b></p>
<div class="table-contents"><table class="table" summary="Useful Hints Profile Keys" border="1">
<colgroup>
<col>
<col>
</colgroup>
<tbody>
<tr>
<td><span class="bold"><strong>Key Attributes </strong></span></td>
<td><span class="bold"><strong>Description</strong></span></td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>N/A<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>execution.site<span class="bold"><strong><br>
Scope       :</strong></span> DAX<br>
<span class="bold"><strong>Since       :</strong></span> 4.5<br>
<span class="bold"><strong>Type        : </strong></span>String<br>
</p></div></td>
<td>the execution site where a job should be
              executed.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>N/A<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>pfn<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 4.5<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>the physical file name to the main executable that a job
              refers to. Overrides any entries specified in the transformation
              catalog.</td>
</tr>
<tr>
<td><div class="literallayout"><p><span class="bold"><strong><span class="bold"><strong>Property Key: </strong></span></strong></span>hints.grid.jobtype<span class="bold"><strong><span class="bold"><strong><br>
Profile  Key: </strong></span></strong></span>grid.jobtype<span class="bold"><strong><br>
Scope       :</strong></span> TC, SC, DAX, Properties<br>
<span class="bold"><strong>Since       :</strong></span> 4.5<br>
<span class="bold"><strong>Type        : </strong></span>String</p></div></td>
<td>applicable when submitting to remote sites via GRAM. The
              site catalog allows you to associate multiple jobmanagers with a
              GRAM site, for different type of jobs [compute, auxillary,
              transfer, register, cleanup ] that Pegasus generates in the
              executable workflow. This profile is usually used to ensure that
              a compute job executes on another job manager. For example, if
              in site catalog you have headnode.example.com/jobmanager-condor
              for compute jobs, and headnode.example.com/jobmanager-fork for
              auxillary jobs. Associating this profile and setting value to
              auxillary for a compute job, will cause the compute job to run
              on the fork jobmanager instead of the condor jobmanager.</td>
</tr>
</tbody>
</table></div>
</div>
<br class="table-break">
</div>
</div><div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="configuration.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="configuration.php">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="properties.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">Chapter 13. Configuration </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> 13.3. Properties</td>
</tr>
</table>
</div><?php  
            pegasus_footer();
        ?>
