#!/usr/bin/env python
#
# @package      hubzero-trac-mysqlauthz
# @file         setup.py
# @author       Nicholas J. Kisseberth <nkissebe@purdue.edu>
# @copyright    Copyright (c) 2010 Purdue University. All rights reserved.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2010 Purdue University
# All rights reserved.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of Purdue University.
#

from setuptools import setup, find_packages

PACKAGE = 'HubzeroPlugin'
VERSION = '0.8.3'

setup (
    name = PACKAGE,
    version = VERSION,
    description = 'HUBzero MySQL Trac Authorization Plugin',
    author = 'Nicholas J. Kisseberth',
    author_email = 'nkissebe@purdue.edu',
    license='LGPL', 
    url='http://hubzero.org',
    keywords = "hubzero trac mysql permission group acl",
    packages = find_packages(exclude=['ez_setup', '*.tests*']),
    package_data = { },
    entry_points = {
        'trac.plugins': [
            'hubzeroplugin.api = hubzeroplugin.api',
        ]
    }
)
