#!/usr/bin/python
#
# @package      hubzero-trac-mysqlauthz
# @file         setup.py
# @author       Nicholas J. Kisseberth <nkissebe@purdue.edu>
# @copyright    Copyright (c) 2010-2015 HUBzero Foundation, LLC.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2010-2015 HUBzero Foundation, LLC.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
'''
hubzero-trac-mysqlauthz is a python plugin for Trac
to authorize Trac projects via a HUBzero mySQL database
'''

# 1.3 change:
# entry point to 'hubzero.trac.mysqlauthz.api = hubzero.trac.mysqlauthz.api',
#    name = 'hubzero-trac-mysqlauthz',
#    version = '1.3.0',
#    packages = ['hubzero.trac.mysqlauthz'],

classifiers = '''\
Development Status :: 5 - Production/Stable
License :: OSI Approved :: MIT License
Operating System :: POSIX :: Linux
Programming Language :: Python\
'''.split('\n')

import os
from setuptools import setup

setup (
    name = 'hubzeroplugin',
    version = '2.2.0',
    license = 'MIT License', 
    description = 'HUBzero Trac MySQL authorization plugin',
    classifiers = classifiers,
    url='http://hubzero.org',
    author = 'Nicholas J. Kisseberth',
    author_email = 'nkissebe@purdue.edu',
    keywords = "hubzero trac mysql permission group acl",
    packages = ['hubzeroplugin', 'hubzero.trac.mysqlauthz'],
    package_data = { },
    entry_points = {
        'trac.plugins': [
            'hubzeroplugin.api = hubzeroplugin.api',
        ]
    }
)
