# @package      hubzero-python
# @file         setup.py
# @author       Nicholas J. Kisseberth <nkissebe@purdue.edu>
# @copyright    Copyright (c) 2012-2014 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2012-2014 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
'''
hubzero-python is a library of python
routines for manipulating the HUBzero
platform.
'''

classifiers = '''\
Development Status :: 5 - Production/Stable
License :: OSI Approved :: GNU Lesser General Public License v3 or later (LGPLv3+)
Operating System :: POSIX :: Linux
Programming Language :: Python\
'''.split('\n')

import os
from distutils.core import setup

setup(
    name='hubzero-trac',
    version='1.3.0',
    license = 'GNU LGPL 3+',
    description='HUBzero Trac support code',
    classifiers = classifiers,
    url='http://hubzero.org',
    author='Nicholas J. Kisseberth',
    author_email='nkissebe@purdue.edu',
    packages=['hubzero.trac'],
)

# vim:ts=4 sw=4 et
