# @package      hubzero-use
# @file         environ.sh
# @author       Rick Kennell <kennell@purdue.edu>
# @copyright    Copyright (c) 2006-2014 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2006-2014 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#cd /
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#

# To adjust software environments...
use ()
{
  eval `/etc/environ sh use $*`
}
unuse ()
{
  eval `/etc/environ sh unuse $*`
}

ENVIRON_CONFIG_DIRS="/etc/environ.d"
export ENVIRON_CONFIG_DIRS

if [ -d /etc/environ.conf.d ]; then
  for i in /etc/environ.conf.d/*.sh; do
    if [ -r $i ]; then
      . $i
    fi
  done
  unset i
fi
