/**
 * @package     hubzero-vncproxy
 * @file		log.h
 * @author      Nicholas J. Kisseberth <nkissebe@purdue.edu>
 * @copyright   Copyright (c) 2010-2012 HUBzero Foundation, LLC.
 * @license     http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
 *
 * Copyright (c) 2010-2012 HUBzero Foundation, LLC.
 *
 * This file is part of: The HUBzero(R) Platform for Scientific Collaboration
 *
 * The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
 * software: you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * HUBzero is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * HUBzero is a registered trademark of HUBzero Foundation, LLC.
 */

#include <syslog.h>

extern int log_priority;
extern int syslog_priority;

#define MLOG_EMERG   __FILE__,__LINE__,LOG_EMERG
#define MLOG_ALERT   __FILE__,__LINE__,LOG_ALERT
#define MLOG_CRIT    __FILE__,__LINE__,LOG_CRIT
#define MLOG_ERR     __FILE__,__LINE__,LOG_ERR
#define MLOG_WARNING __FILE__,__LINE__,LOG_WARNING
#define MLOG_NOTICE  __FILE__,__LINE__,LOG_NOTICE
#define MLOG_INFO    __FILE__,__LINE__,LOG_INFO
#define MLOG_DEBUG   __FILE__,__LINE__,LOG_DEBUG

extern void logmsg(char *file, int line, int priority, char *msg, ...);
