#!/usr/bin/python
#
# @package		hubzero-addrepo
# @file			gensvnapache.py
# @author		Nicholas J. Kisseberth <nkissebe@purdue.edu>
# @copyright	Copyright (c) 2010-2011 Purdue University. All rights reserved.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2010-2011 Purdue University
# All rights reserved.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of Purdue University.
#

# Really quick and dirty port of the perl script of similar name
# but querying project data from MySQL instead of LDAP.
# This should get cleaned up an rewritten to use
# the hubzero python library (which isn't ready
# at the time of this writing).
#

import os
import ConfigParser
import re
import MySQLdb
import string
import sys

db = False
dbcursor = False

data = {}
data['joomla'] = {}
data['hubzero'] = {}
config = ConfigParser.RawConfigParser()
config.read('/etc/hubzero.conf')
section = config.get('default','site')
docroot = config.get(section, 'DocumentRoot')

file_read = open(docroot + '/configuration.php',"r")
contents = file_read.read()
file_read.close()
for m in re.finditer("\s*var\s+\$([a-zA-Z-_0-9]+)\s*=\s*([a-zA-Z-_\'\"\&\~\+\.0-9@]+)\s*;", contents):
  data['joomla'][m.group(1)] = m.group(2).strip(" \'\"\t")

file_read = open(docroot + '/hubconfiguration.php',"r")
contents = file_read.read()
file_read.close()
for m in re.finditer("\s*var\s+\$([a-zA-Z-_0-9]+)\s*=\s*([a-zA-Z-_\\\,\=\!\/\~\+\:\'\"\.0-9@\+]+)\s*;", contents):
  data['hubzero'][m.group(1)] = string.replace(m.group(2).strip(" \'\"\t"),"\\'","'")

mysql_host = data['joomla']['host']
mysql_user = data['joomla']['user']
mysql_password = data['joomla']['password']
mysql_db = data['joomla']['db']
ldapbase = data['hubzero']['hubLDAPBaseDN']
ldaphost = data['hubzero']['hubLDAPMasterHost']
ldapbinduser = data['hubzero']['hubLDAPSearchUserDN']
ldapbindpass = data['hubzero']['hubLDAPSearchUserPW']
ldapgroupobjectclass = 'hubGroup'
try:
  ldapgroupobjectclass = data['hubzero']['hubLDAPGroupObjectClass']
except:
  pass

if (ldapgroupobjectclass != 'posixGroup'):
  ldapgroupobjectclass = 'hubGroup'

try:
  db = MySQLdb.connect(host=mysql_host, user=mysql_user, passwd=mysql_password, db=mysql_db)
except:
  pass

if len(sys.argv) != 5 and len(sys.argv) != 6:
    print "Usage: " + sys.argv[0] + " svn_root_path svn_url_path hub_path [type]"
    sys.exit(1)

svnroot = sys.argv[1]
svnurl = sys.argv[2]
hubdir = sys.argv[3]
svnauthz = False

if len(sys.argv) == 5:
  type = sys.argv[4]
else:
  type = None

if (not os.path.isdir(svnroot)):
  print "Error:  '" + svnroot + "' is not a valid directory."
  sys.exit(2)

if (not os.path.isdir(hubdir)):
  print "Error: '" + hubdir + "' is not a valid directory."
  sys.exit(3)

if not db:
  print "Error: Unable to connect to HUBzero database."
  sys.exit(4)

cursor = db.cursor()

if not cursor:
  print "Error: Unable to obtain HUBzero database cursor."
  sys.exit(5)

dirlist = os.listdir(svnroot)

print "#"
print "# Apache configuration for SVN repositories";
print "#";
print "# This file is generated automatically from MySQL.";
print "#      !!!  DO NOT MODIFY THIS FILE  !!!";
print "#";
print "";

for dir in dirlist:
    if (not os.path.isdir(svnroot + '/' + dir)):
	continue

    id = dir
    if (type == 'group'):
      gid = []
      sourcepublic = False
      gid.append(id)
      gid.append('apps')
      name=id
    else:
      gid = set([])
      cursor.execute("SELECT title,codeaccess,tg.cn FROM jos_tool_version AS tv, jos_tool_groups AS tg WHERE tg.toolid=tv.toolid AND tv.toolname='" + id + "' AND state='3' AND (tg.role=1 or tg.role=2)")
      rows = cursor.fetchall()
      name = id
      for name,sourcepublic,gidref in rows:
        if (sourcepublic == '@OPEN'):
          sourcepublic = True
        else:
          sourcepublic = False
        gid.add(gidref)
      #if (len(gid) == 0):
      #	  print name + " has no groups"

    if (os.path.isfile(svnroot + "/" + id + "/conf/svnauthz.conf")):
      svnauthz = True
    else:
      svnauthz = False

    url = string.replace(svnurl, "@PROJECT@", id)

    print "<Location " + url + ">"
    print "\tDAV svn"
    print "\tSVNPath " + svnroot + "/" + id
    print "\tAuthType Basic"
    print "\tAuthBasicProvider ldap"
    print "\tAuthName \"" + name + " Subversion Repository\""
    print "\tAuthzLDAPAuthoritative on"
    if (ldapbinduser != ""):
      print "\tAuthLDAPBindDN \"" + ldapbinduser + "\""
      print "\tAuthLDAPBindPassword \"" + ldapbindpass + "\""
    if (ldapgroupobjectclass == 'hubGroup'):
      print "\tAuthLDAPGroupAttributeIsDN on"
      print "\tAuthLDAPGroupAttribute owner"
      print "\tAuthLDAPGroupAttribute member"
    else:
      print "\tAuthLDAPGroupAttributeIsDN off"
      print "\tAuthLDAPGroupAttribute memberUid"

    print "\tAuthLDAPURL " + ldaphost + "/ou=users," + ldapbase 

    if svnauthz:
      print "\tAuthzSVNAccessFile " + svnroot + "/" + id + "/conf/svnauthz.conf"
      print "\tRequire valid-user"
      if sourcepublic:
        print "\tSatisfy Any"
    else:
      if sourcepublic:
        print "\t<LimitExcept GET PROPFIND OPTIONS REPORT>"
      for group in gid:
        if sourcepublic:
          print "\t",
        if (ldapgroupobjectclass == 'hubGroup'):
          print "\tRequire ldap-group gid=" + group  + ",ou=groups," + ldapbase
        else:
          print "\tRequire ldap-group cn=" + group  + ",ou=groups," + ldapbase
      if sourcepublic:
        print "\t</LimitExcept>"

    print "</Location>"
    print ""
 
