/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.texture;

import java.util.ArrayList;
import java.util.HashMap;
import org.web3d.image.NIOBufferImage;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLComposedTextureNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLTexture3DNodeType;
import org.web3d.vrml.nodes.VRMLTextureListener;
import org.web3d.vrml.nodes.VRMLTextureNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseTexture3DNode;

public class BaseComposedTexture3D
extends BaseTexture3DNode
implements VRMLTextureListener,
VRMLComposedTextureNodeType {
    protected static final int FIELD_TEXTURE = 4;
    protected static final int LAST_COMPOSED_3DTEXTURE_INDEX = 4;
    protected static final int NUM_FIELDS = 5;
    private static final String TEXTURE_PROTO_MSG = "Proto does not describe a Texture object";
    private static final String TEXTURE_NODE_MSG = "Node does not describe a Texture object";
    protected static final VRMLFieldDeclaration[] fieldDecl;
    protected static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected ArrayList vfTexture = new ArrayList();
    private VRMLNodeType[] kids;

    protected BaseComposedTexture3D() {
        super("ComposedTexture3D");
        this.hasChanged = new boolean[5];
    }

    protected BaseComposedTexture3D(VRMLNodeType vRMLNodeType) {
        this();
        this.copy((VRMLTexture3DNodeType)vRMLNodeType);
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        int n = this.vfTexture.size();
        for (int i = 0; i < n; ++i) {
            VRMLTextureNodeType vRMLTextureNodeType = (VRMLTextureNodeType)this.vfTexture.get(i);
            vRMLTextureNodeType.setupFinished();
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 4) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 69;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 4: {
                if (this.kids == null || this.kids.length != this.vfTexture.size()) {
                    this.kids = new VRMLNodeType[this.vfTexture.size()];
                }
                this.vfTexture.toArray(this.kids);
                vRMLFieldData.clear();
                vRMLFieldData.nodeArrayValue = this.kids;
                vRMLFieldData.dataType = (short)13;
                vRMLFieldData.numElements = this.kids.length;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 4: {
                    if (this.kids == null || this.kids.length != this.vfTexture.size()) {
                        this.kids = new VRMLNodeType[this.vfTexture.size()];
                    }
                    this.vfTexture.toArray(this.kids);
                    vRMLNodeType.setValue(n2, this.kids, this.kids.length);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 4: {
                if (!this.inSetup) {
                    this.vfTexture.clear();
                    this.textureDepth = 0;
                }
                if (vRMLNodeType != null) {
                    ++this.textureDepth;
                    this.addTextureNode(vRMLNodeType);
                }
                if (this.inSetup) break;
                this.hasChanged[4] = true;
                this.fireFieldChanged(4);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 4: {
                if (!this.inSetup) {
                    this.vfTexture.clear();
                    this.textureDepth = 0;
                }
                if (n2 % 2 != 0) {
                    System.out.println("ComposedTexture3D: Number of textures not multiple of 2");
                }
                for (int i = 0; i < n2; ++i) {
                    ++this.textureDepth;
                    this.addTextureNode(vRMLNodeTypeArray[i]);
                }
                if (this.inSetup) break;
                this.hasChanged[4] = true;
                this.fireFieldChanged(4);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeTypeArray, n2);
            }
        }
    }

    public String getCacheString(int n) {
        VRMLTextureNodeType vRMLTextureNodeType = (VRMLTextureNodeType)this.vfTexture.get(n);
        if (vRMLTextureNodeType == null) {
            return null;
        }
        return vRMLTextureNodeType.getCacheString(0);
    }

    public int getNumberTextures() {
        return this.vfTexture.size();
    }

    public void getTextures(int n, VRMLTextureNodeType[] vRMLTextureNodeTypeArray) {
        int n2 = this.vfTexture.size();
        for (int i = 0; i < n2; ++i) {
            vRMLTextureNodeTypeArray[i + n] = (VRMLTextureNodeType)this.vfTexture.get(i);
        }
    }

    public void textureImageChanged(int n, VRMLNodeType vRMLNodeType, NIOBufferImage nIOBufferImage, String string) {
        int n2 = this.vfTexture.indexOf(vRMLNodeType);
        if (n2 != -1) {
            this.fireTextureImageChanged(n2, vRMLNodeType, nIOBufferImage, string);
        }
    }

    public void textureImageChanged(int n, VRMLNodeType[] vRMLNodeTypeArray, NIOBufferImage[] nIOBufferImageArray, String[] stringArray) {
    }

    public void textureParamsChanged(int n, int n2, int n3, int n4, float f, float[] fArray) {
    }

    public void textureParamsChanged(int n, int[] nArray, int[] nArray2, int[] nArray3, float f, float[] fArray) {
    }

    protected void addTextureNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            if (!(vRMLNodeType2 instanceof VRMLTextureNodeType)) {
                throw new InvalidFieldValueException(TEXTURE_PROTO_MSG);
            }
            this.vfTexture.add(vRMLNodeType2);
            ((VRMLTextureNodeType)vRMLNodeType).addTextureListener(this);
        } else {
            if (!(vRMLNodeType instanceof VRMLTextureNodeType)) {
                throw new InvalidFieldValueException(TEXTURE_NODE_MSG);
            }
            this.vfTexture.add(vRMLNodeType);
            ((VRMLTextureNodeType)vRMLNodeType).addTextureListener(this);
        }
    }

    static {
        nodeFields = new int[]{4, 0};
        fieldDecl = new VRMLFieldDeclaration[5];
        fieldMap = new HashMap(15);
        BaseComposedTexture3D.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseComposedTexture3D.fieldDecl[4] = new VRMLFieldDeclaration(3, "MFNode", "texture");
        BaseComposedTexture3D.fieldDecl[1] = new VRMLFieldDeclaration(2, "SFBool", "repeatS");
        BaseComposedTexture3D.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFBool", "repeatT");
        BaseComposedTexture3D.fieldDecl[3] = new VRMLFieldDeclaration(2, "SFBool", "repeatR");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(4);
        fieldMap.put("texture", n);
        fieldMap.put("set_texture", n);
        fieldMap.put("texture_changed", n);
        fieldMap.put("repeatS", new Integer(1));
        fieldMap.put("repeatT", new Integer(2));
        fieldMap.put("repeatR", new Integer(3));
    }
}

