<?php
/**
 * HUBzero CMS
 *
 * Copyright 2005-2011 Purdue University. All rights reserved.
 *
 * This file is part of: The HUBzero(R) Platform for Scientific Collaboration
 *
 * The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
 * software: you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * HUBzero is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * HUBzero is a registered trademark of Purdue University.
 *
 * @package   hubzero-cms
 * @copyright Copyright 2005-2011 Purdue University. All rights reserved.
 * @license   http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

$text = ($this->task == 'edit' ? JText::_('Edit Employer Type') : JText::_('New Employer Type'));

JToolBarHelper::title(JText::_('Registration') . ': ' . $text, 'user.png');
JToolBarHelper::save();
JToolBarHelper::cancel();

?>
<script type="text/javascript">
function submitbutton(pressbutton) 
{
	var form = document.adminForm;
	
	if (pressbutton == 'cancelorgtype') {
		submitform(pressbutton);
		return;
	}
	
	submitform(pressbutton);
}
</script>

<form action="index.php" method="post" name="adminForm" id="item-form">
	<fieldset class="adminform">
		<input type="hidden" name="option" value="<?php echo $this->option; ?>" />
		<input type="hidden" name="controller" value="<?php echo $this->controller; ?>" />
		<input type="hidden" name="id" value="<?php echo $this->model->id; ?>" />
		<input type="hidden" name="task" value="save" />

		<table class="admintable">
			<tbody>
				<tr>
					<td class="key"><label for="type"><?php echo JText::_('Type'); ?>:</label></td>
					<td><input type="text" name="type" id="type" value="<?php echo $this->escape($this->model->type); ?>" size="50" /> <span style="color: #aaa">Created from Title if left blank</span></td>
				</tr>
				<tr>
					<td class="key"><label for="title"><?php echo JText::_('Title'); ?>:</label></td>
					<td><input type="text" name="title" id="title" value="<?php echo $this->escape($this->model->title); ?>" size="50" /> <span style="color: #c00">required</span></td>
				</tr>
			</tbody>
		</table>
	</fieldset>
	<?php echo JHTML::_('form.token'); ?>
</form>
