<?php
/**
 * HUBzero CMS
 *
 * Copyright 2005-2015 HUBzero Foundation, LLC.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * HUBzero is a registered trademark of Purdue University.
 *
 * @package   hubzero-cms
 * @author    Alissa Nedossekina <alisa@purdue.edu>
 * @copyright Copyright 2005-2015 HUBzero Foundation, LLC.
 * @license   http://opensource.org/licenses/MIT MIT
 */

namespace Components\Wishlist\Admin;

// Authorization check
if (!\User::authorise('core.manage', 'com_wishlist'))
{
	return \App::abort(404, \Lang::txt('JERROR_ALERTNOAUTHOR'));
}

// Include scripts
include_once(dirname(__DIR__) . DS . 'tables' . DS . 'wishlist.php');
include_once(dirname(__DIR__) . DS . 'tables' . DS . 'owner.php');
include_once(dirname(__DIR__) . DS . 'tables' . DS . 'ownergroup.php');
include_once(dirname(__DIR__) . DS . 'tables' . DS . 'wish.php');
include_once(dirname(__DIR__) . DS . 'tables' . DS . 'wish' . DS . 'plan.php');
include_once(dirname(__DIR__) . DS . 'tables' . DS . 'wish' . DS . 'rank.php');
include_once(dirname(__DIR__) . DS . 'tables' . DS . 'wish' . DS . 'attachment.php');
include_once(dirname(__DIR__) . DS . 'helpers' . DS . 'permissions.php');

$controllerName = \Request::getCmd('controller', 'lists');
if (!file_exists(__DIR__ . DS . 'controllers' . DS . $controllerName . '.php'))
{
	$controllerName = 'lists';
}

\Submenu::addEntry(
	\Lang::txt('COM_WISHLIST_LISTS'),
	\Route::url('index.php?option=com_wishlist&controller=lists'),
	($controllerName == 'lists')
);
\Submenu::addEntry(
	\Lang::txt('COM_WISHLIST_WISHES'),
	\Route::url('index.php?option=com_wishlist&controller=wishes&wishlist=-1'),
	($controllerName == 'wishes')
);
\Submenu::addEntry(
	\Lang::txt('COM_WISHLIST_COMMENTS'),
	\Route::url('index.php?option=com_wishlist&controller=comments&wish=-1'),
	($controllerName == 'comments')
);

require_once(__DIR__ . DS . 'controllers' . DS . $controllerName . '.php');
$controllerName = __NAMESPACE__ . '\\Controllers\\' . ucfirst($controllerName);

// Initiate controller
$controller = new $controllerName();
$controller->execute();
$controller->redirect();

