/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.IOException;

class ButtonPanel
extends Panel
implements ActionListener {
    VncViewer viewer;
    Button disconnectButton;
    Button optionsButton;
    Button recordButton;
    Button clipboardButton;
    Button ctrlAltDelButton;
    Button refreshButton;
    Button enableVideoButton;
    Button selectButton;
    Button videoFreezeButton;
    final String videoOffLabel = "Video Off";
    final String videoOnLabel = "Video On";
    final String selectEnterLabel = "Select Video Area";
    final String selectLeaveLabel = "Hide Selection";
    final String videoFreezeLabel = " Freeze Video  ";
    final String videoUnfreezeLabel = "Unfreeze Video";

    ButtonPanel(VncViewer vncViewer) {
        this.viewer = vncViewer;
        this.setLayout(new FlowLayout(0, 0, 0));
        this.disconnectButton = new Button("Disconnect");
        this.disconnectButton.setEnabled(false);
        this.add(this.disconnectButton);
        this.disconnectButton.addActionListener(this);
        this.optionsButton = new Button("Options");
        this.add(this.optionsButton);
        this.optionsButton.addActionListener(this);
        this.clipboardButton = new Button("Clipboard");
        this.clipboardButton.setEnabled(false);
        this.add(this.clipboardButton);
        this.clipboardButton.addActionListener(this);
        if (this.viewer.rec != null) {
            this.recordButton = new Button("Record");
            this.add(this.recordButton);
            this.recordButton.addActionListener(this);
        }
        this.ctrlAltDelButton = new Button("Send Ctrl-Alt-Del");
        this.ctrlAltDelButton.setEnabled(false);
        this.add(this.ctrlAltDelButton);
        this.ctrlAltDelButton.addActionListener(this);
        this.refreshButton = new Button("Refresh");
        this.refreshButton.setEnabled(false);
        this.add(this.refreshButton);
        this.refreshButton.addActionListener(this);
    }

    public void addVideoOffButton() {
        this.enableVideoButton = new Button("Video Off");
        this.enableVideoButton.setEnabled(false);
        this.add(this.enableVideoButton);
        this.enableVideoButton.addActionListener(this);
    }

    public void addSelectButton() {
        this.selectButton = new Button("Select Video Area");
        this.selectButton.setEnabled(false);
        this.add(this.selectButton);
        this.selectButton.addActionListener(this);
    }

    public void addVideoFreezeButton() {
        this.videoFreezeButton = new Button(" Freeze Video  ");
        this.videoFreezeButton.setEnabled(false);
        this.add(this.videoFreezeButton);
        this.videoFreezeButton.addActionListener(this);
    }

    public void enableButtons() {
        this.disconnectButton.setEnabled(true);
        this.clipboardButton.setEnabled(true);
        this.refreshButton.setEnabled(true);
        if (this.enableVideoButton != null) {
            this.enableVideoButton.setEnabled(true);
        }
        if (this.selectButton != null) {
            this.selectButton.setEnabled(true);
        }
        if (this.videoFreezeButton != null) {
            this.videoFreezeButton.setEnabled(true);
        }
    }

    public void disableButtonsOnDisconnect() {
        this.remove(this.disconnectButton);
        this.disconnectButton = new Button("Hide desktop");
        this.disconnectButton.setEnabled(true);
        this.add((Component)this.disconnectButton, 0);
        this.disconnectButton.addActionListener(this);
        this.optionsButton.setEnabled(false);
        this.clipboardButton.setEnabled(false);
        this.ctrlAltDelButton.setEnabled(false);
        this.refreshButton.setEnabled(false);
        if (this.enableVideoButton != null) {
            this.enableVideoButton.setEnabled(false);
        }
        if (this.selectButton != null) {
            this.selectButton.setEnabled(false);
        }
        if (this.videoFreezeButton != null) {
            this.videoFreezeButton.setEnabled(false);
        }
    }

    public void enableRemoteAccessControls(boolean bl) {
        this.ctrlAltDelButton.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.viewer.moveFocusToDesktop();
        if (actionEvent.getSource() == this.disconnectButton) {
            this.viewer.disconnect();
        } else if (actionEvent.getSource() == this.optionsButton) {
            this.viewer.options.setVisible(!this.viewer.options.isVisible());
        } else if (actionEvent.getSource() == this.recordButton) {
            this.viewer.rec.setVisible(!this.viewer.rec.isVisible());
        } else if (actionEvent.getSource() == this.clipboardButton) {
            this.viewer.clipboard.setVisible(!this.viewer.clipboard.isVisible());
        } else if (actionEvent.getSource() == this.ctrlAltDelButton) {
            try {
                KeyEvent keyEvent = new KeyEvent(this, 401, 0L, 10, 127);
                this.viewer.rfb.writeKeyEvent(keyEvent);
                keyEvent = new KeyEvent(this, 402, 0L, 10, 127);
                this.viewer.rfb.writeKeyEvent(keyEvent);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (actionEvent.getSource() == this.refreshButton) {
            try {
                RfbProto rfbProto = this.viewer.rfb;
                rfbProto.writeFramebufferUpdateRequest(0, 0, rfbProto.framebufferWidth, rfbProto.framebufferHeight, false);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (this.enableVideoButton != null && actionEvent.getSource() == this.enableVideoButton) {
            boolean bl = this.enableVideoButton.getLabel().equals("Video On");
            try {
                this.viewer.rfb.trySendVideoEnable(bl);
                this.enableVideoButton.setLabel(bl ? "Video Off" : "Video On");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (this.selectButton != null && actionEvent.getSource() == this.selectButton) {
            if (this.viewer.vc != null) {
                boolean bl = this.viewer.vc.isInSelectionMode();
                if (!bl) {
                    this.selectButton.setLabel("Hide Selection");
                    this.viewer.vc.enableSelection(true);
                } else {
                    this.selectButton.setLabel("Select Video Area");
                    this.viewer.vc.enableSelection(false);
                }
            }
        } else if (this.videoFreezeButton != null && actionEvent.getSource() == this.videoFreezeButton) {
            boolean bl = this.videoFreezeButton.getLabel().equals(" Freeze Video  ");
            try {
                this.viewer.rfb.trySendVideoFreeze(bl);
                this.videoFreezeButton.setLabel(bl ? "Unfreeze Video" : " Freeze Video  ");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

