<?php
/**
 * HUBzero CMS
 *
 * Copyright 2005-2015 HUBzero Foundation, LLC.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * HUBzero is a registered trademark of Purdue University.
 *
 * @package   hubzero-cms
 * @copyright Copyright 2005-2015 HUBzero Foundation, LLC.
 * @license   http://opensource.org/licenses/MIT MIT
 */

namespace Components\System\Models;

use Hubzero\Database\Relational;

/**
 * media tracking detailed model
 *
 * @uses \Hubzero\Database\Relational
 */
class Mediatrackingdetailed extends Relational
{
	/**
	 * The table to which the class pertains
	 *
	 * This will default to #__{namespace}_{modelName} unless otherwise
	 * overwritten by a given subclass. Definition of this property likely
	 * indicates some derivation from standard naming conventions.
	 *
	 * @var  string
	 **/
	protected $table = '#__media_tracking_detailed';

	/**
	 * Fields and their validation criteria
	 *
	 * @var  array
	 */
	protected $rules = array(
		'session_id'  => 'notempty',
		'ip_address'  => 'notempty',
		'object_id'   => 'positive|nonzero',
		'object_type' => 'notempty'
	);

	/**
	 * Get tracking info for a specific user/object combination
	 *
	 * @param   string  $object_id    Object ID
	 * @param   string  $object_type  Object type
	 * @param   string  $user_id      User ID
	 * @return  object
	 */
	public static function oneByUserAndObject($object_id, $object_type, $user_id = 0)
	{
		$query = self::all()
			->whereEquals('object_id', $object_id)
			->whereEquals('object_type', $object_type);

		if (!$user_id)
		{
			$session_id = \App::get('session')->getId();

			$query->whereEquals('session_id', $session_id);
		}
		else
		{
			$query->whereEquals('user_id', $user_id);
		}

		return $quer->limit(1)->row();
	}
}
