/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.cert.Certificate;

class TrustDialog
implements ActionListener {
    String msg;
    String host;
    String text;
    int port;
    Certificate[] trustallCerts = null;
    boolean viewing_cert = false;
    boolean trust_this_session = false;
    Button ok;
    Button cancel;
    Button viewcert;
    TextArea textarea;
    Checkbox accept;
    Checkbox deny;
    Dialog dialog;
    String s1 = "Accept this certificate temporarily for this session";
    String s2 = "Do not accept this certificate and do not connect to this VNC server";
    String ln = "\n---------------------------------------------------\n\n";

    TrustDialog(String string, int n, Certificate[] certificateArray) {
        this.host = string;
        this.port = n;
        this.trustallCerts = certificateArray;
        this.msg = "VNC Server " + this.host + ":" + this.port + " Not Verified";
    }

    public boolean queryUser() {
        Object object;
        Frame frame = new Frame(this.msg);
        this.dialog = new Dialog(frame, true);
        String string = "";
        if (this.trustallCerts.length == 1) {
            object = new CertInfo(this.trustallCerts[0]);
            string = ((CertInfo)object).get_certinfo("all");
        }
        this.text = "\nUnable to verify the identity of\n\n        " + this.host + ":" + this.port + "\n" + "\n" + string + "\n" + "as a trusted VNC server.\n" + "\n" + "This may be due to:\n" + "\n" + " - Your requesting to View the Certificate before accepting.\n" + "\n" + " - The VNC server using a Self-Signed Certificate.\n" + "\n" + " - The VNC server using a Certificate Authority not recognized by your\n" + "   Browser or Java Plugin runtime.\n" + "\n" + " - The use of an Apache SSL portal employing CONNECT proxying and the\n" + "   Apache web server has a certificate different from the VNC server's. \n" + "\n" + " - A Man-In-The-Middle attack impersonating as the VNC server you wish\n" + "   to connect to.  (Wouldn't that be exciting!!)\n" + "\n" + "By safely copying the VNC server's Certificate (or using a common\n" + "Certificate Authority certificate) you can configure your Web Browser or\n" + "Java Plugin to automatically authenticate this Server.\n" + "\n" + "If you do so, then you will only have to click \"Yes\" when this VNC\n" + "Viewer applet asks you whether to trust your Browser/Java Plugin's\n" + "acceptance of the certificate. (except for the Apache portal case above.)\n";
        object = new CheckboxGroup();
        this.accept = new Checkbox(this.s1, true, (CheckboxGroup)object);
        this.deny = new Checkbox(this.s2, false, (CheckboxGroup)object);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 1));
        panel.add(this.accept);
        panel.add(this.deny);
        this.ok = new Button("OK");
        this.cancel = new Button("Cancel");
        this.viewcert = new Button("View Certificate");
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.viewcert.addActionListener(this);
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(0));
        panel2.add(this.viewcert);
        panel2.add(this.ok);
        panel2.add(this.cancel);
        Label label = new Label(this.msg, 1);
        label.setFont(new Font("Helvetica", 1, 16));
        this.textarea = new TextArea(this.text, 36, 64, 1);
        this.textarea.setEditable(false);
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(2, 1));
        panel3.add(panel);
        panel3.add(panel2);
        this.dialog.setLayout(new BorderLayout());
        this.dialog.add("North", label);
        this.dialog.add("South", panel3);
        this.dialog.add("Center", this.textarea);
        this.dialog.pack();
        this.dialog.resize(this.dialog.preferredSize());
        this.dialog.show();
        return this.trust_this_session;
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.viewcert) {
            if (this.viewing_cert) {
                this.textarea.setText(this.text);
                this.viewcert.setLabel("View Certificate");
                this.viewing_cert = false;
            } else {
                this.textarea.setText("");
                for (int i = 0; i < this.trustallCerts.length; ++i) {
                    int n = i + 1;
                    this.textarea.append("Certificate[" + n + "]\n\n");
                    this.textarea.append(this.trustallCerts[i].toString());
                    this.textarea.append(this.ln);
                }
                this.viewcert.setLabel("View Info");
                this.viewing_cert = true;
                this.textarea.setCaretPosition(0);
            }
        } else if (actionEvent.getSource() == this.ok) {
            this.trust_this_session = this.accept.getState();
            this.dialog.dispose();
        } else if (actionEvent.getSource() == this.cancel) {
            this.trust_this_session = false;
            this.dialog.dispose();
        }
    }

    String get_certinfo() {
        String string = "";
        String[] stringArray = new String[]{"CN", "OU", "O", "L", "C"};
        if (this.trustallCerts.length < 1) {
            string = "";
            return string;
        }
        String string2 = this.trustallCerts[0].toString();
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string3 = stringArray[i] + "=";
            int n2 = string2.indexOf(string3, 0);
            if (n2 <= 0) continue;
            int n3 = string2.indexOf(", ", n2);
            int n4 = string2.indexOf("\n", n2);
            if (n3 < 0 && n4 < 0 || (n = n3 < 0 ? n4 : (n4 < 0 ? n3 : (n3 < n4 ? n3 : n4))) <= n2) continue;
            String string4 = string2.substring(n2, n);
            string = string + "        " + string4 + "\n";
        }
        return string;
    }
}

