#!/bin/sh
#
# @package      hubzero-forge
# @file         addrepo.sh
# @author       Steven M. Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2006-2018 HUBzero Foundation, LLC.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2006-2018 HUBzero Foundation, LLC.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademak of HUBzero Foundation, LLC.
#

repoHost=$1
shift

#isPython35=0
#for scl in ${X_SCLS} ; do
#   if [ ${scl} = rh-python35 ] ; then
#      isPython35=1
#   fi
#done
#
#if [ ${isPython35} -eq 0 ] ; then
#   source scl_source enable rh-python35
#fi

case ${repoHost} in
   svnLocal)
      addrepoScript=/usr/bin/addrepoSVN.py
      ;;
   gitLocal)
      addrepoScript=/usr/bin/addrepoGIT.py
      ;;
   gitExternal)
      if [ -x /var/www/.ssh-toolgit/toolgit.sh ] ; then
         GIT_SSH=/var/www/.ssh-toolgit/toolgit.sh
         export GIT_SSH
      fi
      addrepoScript=/usr/bin/addrepoGITexternal.py
      ;;
   *)
      echo "$0: repoHost must be one of svnLocal, gitLocal, or gitExternal."
      exit 1
      ;;
esac

exec ${addrepoScript} "$@"
