module.exports = function(hg, done) {
	hg.event.observe('onContentLoaded', function(client) {
		var getSql = function(id, itemId) {
			var collections = [
				'SELECT \'collections\' AS domain, id, title, description AS body, ',
				'CONCAT(\'/\', object_type, \'s/\', CASE WHEN object_type = \'group\' THEN (SELECT cn FROM jos_xgroups WHERE gidNumber = object_id) ELSE object_id END, \'/collections/\', alias) AS link, ',
				'access, ', // 0 == public, other == private
				'CASE WHEN object_type = \'group\'  THEN object_id ELSE NULL END AS group_ids, ',
				'CASE WHEN object_type = \'member\' THEN object_id ELSE NULL END AS contributor_ids, ',
				'CASE WHEN object_type = \'group\'  THEN \'Group collection\' ELSE \'Member collection\' END AS type ',
				'FROM jos_collections',
				'WHERE state = 1'
			];
			if (id) {
				collections.push('WHERE id = ' + id);
				return [collections.join(' ')];
			}

			var collectionItems = [
				'SELECT \'collection items\' AS domain, ci.id, ci.title, ci.description AS body, ',
				'CONCAT(\'/collections/posts/\', cp.id) AS link, ',
				'(SELECT group_concat(DISTINCT jto.tagid separator \'\\n\') FROM jos_tags_object jto INNER JOIN jos_tags jt ON jt.id = jto.tagid WHERE jto.tbl = \'bulletinboard\' AND jto.objectid = ci.id) AS tag_ids,',
				'CONCAT(CASE WHEN c.object_type = \'group\'  THEN \'Group collection - \' ELSE \'Member collection - \' END, c.title) AS type, ',
				'CASE WHEN c.object_type = \'group\'  THEN c.object_id ELSE NULL END AS group_ids, ',
				'ci.created_by AS contributor_ids ',
				'FROM jos_collections_items ci',
				'INNER JOIN jos_collections_posts cp ON cp.item_id = ci.id',
				'INNER JOIN jos_collections c ON c.id = cp.collection_id AND c.state = 1',
				'WHERE ci.state = 1'
			];
			if (itemId) {
				collectionItems.push('AND ci.id = ' + id);
				return [collectionItems.join(' ')];
			}
			return [collections.join(' '), collectionItems.join(' ')];
		};

		var query = function(client, cb, id, itemId) {
			var statements = getSql(id, itemId);
			statements.forEach(function(sql, idx) {
				client.query(sql, function(err, results) {
					if (err) {
						throw err;
					}
					cb(results, idx == statements.length - 1);
				});
			});
		};
		
		query(client, function(results, last) {
			results.forEach(hg.addWithCommonConnections);
			if (last) {
				done();
				hg.event.emit('onCollectionsLoaded', [client]);
			}
		});
	});

	hg.event.observe('onUpdateCollections', function(client, row) {
		query(client, function(results) {
			if (results.length) {
				results.forEach(hg.addWithCommonConnections);
			}
			else {
				hg.remove('collections', row.id);
			}
		}, row.id);
	});

	hg.event.observe('onInsertCollections', function(client, row) {
		query(client, function(results) {
			results.forEach(hg.addWithCommonConnections);
		}, row.id);
	});

	hg.event.observe('onDeleteCollections', function(client, row) {
		hg.remove('collections', row.id);
	});

	hg.event.observe('onUpdateCollectionsItems', function(client, row) {
		query(client, function(results) {
			if (results.length) {
				results.forEach(hg.addWithCommonConnections);
			}
			else {
				hg.remove('collection items', row.id);
			}
		}, null, row.id);
	});

	hg.event.observe('onInsertCollectionsItems', function(client, row) {
		query(client, function(results) {
			results.forEach(hg.addWithCommonConnections);
		}, null, row.id);
	});

	hg.event.observe('onDeleteCollectionsItems', function(client, row) {
		hg.remove('collection items', null, row.id);
	});
};
