module.exports = function(opts) {
	hg = (opts && opts.hg) || require('hubgraph-ext')();
var fs = require('fs'),
  http = require('http'),
  repl = require('repl'),
   sys = require('util'),
replify = require('replify')
;

replify({ 
	'name': 'server',
	'path': hg.conf.hubgraph.root,
	'logger': {
		'warn': hg.log,
		'error': hg.log
	},
	'contexts': {'hg': hg}
});

process.chdir(hg.conf.hubgraph.root);
fs.mkdir(hg.conf.hubgraph.root + '/data', '0660', function() {});

var reload = function() {
	hg.views = {
		'reload': reload
	};
	hg.requireJsExtension('views');
};
reload();

hg.event.observe('onExtensionResourcesLoaded', function(client) {
	hg.event.emit('onStartUpdate', [client]);

	process.on('SIGINT', function () {
		hg.exit();
		process.exit();
	});

	if (!hg.conf.hubgraph.listen) {
		hg.conf.hubgraph.listen = '8124';
	}
	hg.log('Starting server using  ' + hg.conf.hubgraph.listen + '...');
	if (hg.conf.hubgraph.listen.substr(0, 1) == '/') {
		try {	
			fs.unlinkSync(hg.conf.hubgraph.listen);
		}
		catch (ex) {
		}
	}
	var last = null;
	var server = function(req, res) {
		var url = require('url').parse(req.url, true);

		var finish = function(code, out) {
			out = out ? JSON.stringify(out) : '';

			var headers = {
				'Content-Length': out.length
			};
			if (headers['Content-Length']) {
				headers['Content-Type'] = 'application/json';
			}
			else if (code === 200) {
				code = 204;
			}

			res.writeHead(code, headers);
			if (code !== 204) {
				res.write(out);
			}
			res.end();
		};
		if (!req.headers['x-hubgraph-request']) {
			finish(405);
		}
		if (last == req.headers['x-hubgraph-request']) {
			finish(304);
		}
		last = req.headers['x-hubgraph-request'];

		var viewName = url.pathname.match(/^\/views\/(.+)$/);
		if (!viewName) {
			return finish(404);
		}

		switch (req.method) {
			case 'GET':
			case 'HEAD':
				if (!hg.views[viewName[1]]) {
					return finish(404);
				}

				try {
					finish(200, hg.views[viewName[1]](url.query, req.headers));
				}
				catch (ex) {
					hg.log(ex);
					hg.log(ex.stack);
					return finish(500, {error: ex});
				}
			break;
			default: return finish(405);
		}
	};
	http.createServer(server).listen(hg.conf.hubgraph.listen);
	if (hg.conf.hubgraph.listen.substr(0, 1) == '/') {
		fs.chmodSync(hg.conf.hubgraph.listen, 0666);
	}
});


hg.event.observe('onMysqlConnect', function(client) {
	hg.event.emit('onStartBoot', [client]);
});
hg.requireJsExtension('resources', []);

};
