#!/usr/bin/python2.6
# @package      hubzero-mailgateway
# @file         filecopy.py
# @author       David Benham <dbenham@purdue.edu>
# @copyright    Copyright (c) 2012-2013 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2012-2013 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#

import sys
import os
import pwd
import grp
import traceback

try:

	# arguments are passed via stdin for security reasons- it makes
	# the sudo entry this command runs under more secure if no command
	# line args are used, although it makes the whole process more
	# convoluted
	stdinString = sys.stdin.read()
	inputArgs = stdinString.split()

	if len(inputArgs) != 2:
		sys.stderr.write("Error: Two Input file names need to be space deliminted on stdin")
		exit(1)
	else:
		filename1 = inputArgs[0]
		filename2 = inputArgs[1]

	if filename1 != os.path.realpath(filename1):
		sys.stderr.write("os.path.realpath check failed for " + filename1)
		exit(1)

	if filename2 != os.path.realpath(filename2):
		sys.stderr.write("os.path.realpath check failed for " + filename2)
		exit(1)

	f1 = os.open(filename1, (os.O_NOFOLLOW))

	d2 = os.path.dirname(filename2)

	if d2:
		if not os.path.exists(d2):
			os.makedirs(d2)
			os.chown(d2, pwd.getpwnam('www-data')[2], grp.getgrnam('www-data')[2] )

	f2 = os.open(filename2, (os.O_CREAT|os.O_RDWR|os.O_NOFOLLOW))

	# 64 MB limit per file (had to draw a line somewhere)
	f1contents = os.read(f1, (2**26))
	os.write(f2, f1contents)

	os.close(f1)
	os.close(f2)

	sys.stdout.write("copy successful, filelength = " + str(len(f1contents)))

	exit(0)

except Exception, ex:
	sys.stderr.write("\n Exception Encountered:\n" + str(ex) + "\n" + traceback.format_exc())
	exit(1)
