#!/usr/bin/python
# @package      hubzero-mailgateway
# @file         processgroupforumpost.py
# @author       David Benham <dbenham@purdue.edu>
# @copyright    Copyright (c) 2012 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2012 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#

import base64
import cgi
import ConfigParser
import datetime
import email
import errno
import fcntl
import mailproc
import MySQLdb
import os
import re
import smtplib
import string
import subprocess
import sys
import time
import traceback
from Crypto.Cipher import AES
from struct import *

mailproc.openlog()

## after getting log file taken care of, put everything inside a global try except and log all exceptions
try:

	mailproc.log("Email processing started")
	mailproc.log("processgroupforumpost.py started")

	mailproc.loadConfigurationValues()

	## read email into string
	emailtext  = sys.stdin.read()

	## log the entire email
	mailproc.log("Raw Incoming Email Start>>>" + emailtext + "<<<Raw Incoming Email End\n")

	## send to spamc process to test for spam, pipe emailtext to child and get the stdout
	proc = subprocess.Popen("spamc", shell=False, stdin=subprocess.PIPE, stdout=subprocess.PIPE)
	proc.stdin.write(emailtext)
	proc.stdin.close()
	proc.wait()
	emailtext = proc.stdout.read()

	## Spamassassin will put this extended header in SPAM
	match = re.search("X-Spam-Status: Yes", emailtext, flags=re.M | re.S)

	if match:
		mailproc.log("Rejected as SPAM, not processed")
		mailproc.log("Modified SPAM processing Email Start>" + emailtext + "<Modified SPAM processing Email End\n")
	else:

		msg = email.message_from_string(emailtext)
		emailbody = msg.get_payload()

		## Grab text only version of email
		emailbody, emailsubject, emailFromAddress, emailToAddress = mailproc.extractMessageFromEmail(emailtext)

		emailbody = mailproc.cleanEmail(emailbody)

		## See if email is from myself (infinite loops bad)
		if emailFromAddress != mailproc.mailfrom_email:

			userfeedback = emailbody

			## Get the token from the To (it will be in the form hgm-XXX@somehub.org.
			## We need the XXX part
			match = re.search('hgm-(([a-fA-F0-9])+)@', emailToAddress, flags=re.M | re.S)

			if match:
				hubtoken = match.group(1)
			else:
				hubtoken = ''

			mailproc.log("Token " + hubtoken)

			## Decrypt the hubtoken
			version, tokenType, userid, forum_post_id, timestamp = mailproc.decryptEmailToken(hubtoken)

			## Lookup this jos_forum_posts record contained in the token
			mailproc.log("Looking up forum info for forum_post_id = " + str(forum_post_id))
			db = mailproc.db_connect()
			cursor = db.cursor()
			sql  = "SELECT jfp.`id`, jfp.`parent`, jfp.`scope_id`, jfp.`category_id`, jfp.`title` "
			sql += "FROM jos_forum_posts jfp "
			sql += "WHERE jfp.scope= 'group' AND jfp.id = %s "

			data = (forum_post_id)
			cursor.execute(sql, data)
			rs = cursor.fetchone()

			if not rs:
				raise Exception("Cannot obtain info for jos_forum_post with ID " + str(commentid))
			else:
				parent = rs[0]
				groupid = rs[2]
				categoryid = rs[3]
				posttitle = rs[4]

			cursor.close()
			db.close()

			## Look up group name
			mailproc.log("Looking up group informaiton on forum post for groupid " + str(groupid))
			db = mailproc.db_connect()
			cursor = db.cursor()
			sql  = "SELECT xg.`description`, xg.`cn` FROM jos_xgroups xg WHERE xg.gidNumber = %s "
			data = (groupid)
			cursor.execute(sql, data)
			rs = cursor.fetchone()

			if not rs:
				raise Exception("Cannot obtain info for jos_xgroups with ID of " + str(groupid))
			else:
				groupDescription = rs[0]
				groupName = rs[1]

			cursor.close()
			db.close()

			## Do a database insert into the jos_xforum table
			db = mailproc.db_connect()
			cursor = db.cursor ()
			sql = "INSERT INTO jos_forum_posts (`title`, `comment`, `created`, `created_by`, `state`, `sticky`, `parent`, `hits`, `scope`, `scope_id`, `access`, `anonymous`, `modified`, `modified_by`, `category_id`, `last_activity`) "
			sql += "VALUES (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)"

			data = ("Emailed forum response from " + emailFromAddress,
			        userfeedback + "\n---- Emailed forum response from " + emailFromAddress,
			        datetime.datetime.now(),
			        userid,
			        1,
			        0,
			        parent,
			        0,
				"group",
			        groupid,
			        4,
			        0,
			        datetime.datetime.now(),
			        userid,
					categoryid,
			        datetime.datetime.now()
				)

			cursor.execute (sql, data)
			newCommentID = cursor.lastrowid
			db.close()

			## Grab all users of this group who are interested in receiving email about this reply
			mailproc.log("Grabbing all users subscribed to this post")
			db = mailproc.db_connect()
			cursor = db.cursor ()

			sql = "select u.id, u.email "
			sql += "from jos_xgroups_members m "
			sql += "join jos_users u on (u.id = m.uidNumber) "
			sql += "join jos_xgroups_memberoption mo on (mo.gidNumber = m.gidNumber and mo.userID = u.id and mo.optionname = 'receive-forum-email') "
			sql += "where m.gidNumber = %s and mo.optionvalue = 1 "
			data = (groupid)
			cursor.execute(sql, data)
			rows = cursor.fetchall()

			message = "~!~!~!~!~!~!~!~!~!~!" + "\r\n"
			message += "Message from " + mailproc.hubLongURL + "\r\n"
			message += "You can reply to this message, but be sure to include your reply text above this area." + "\r\n\r\n"
			message += emailFromAddress + " wrote:\r\n\r\n"
			message += emailbody

			##Loop through all people who want email notifications of forum posts
			for row in rows:
				mailproc.log('Sending response email to ' + row[1])

				# generate a token for them to respond via email if they wish
				newtoken = mailproc.createEmailToken('01','02', row[0], parent)

				mailproc.sendEmail(row[1],
					mailproc.site_name + ' - ' + groupName + " - " + posttitle,
					message,
				    "",
				    "",
					"hgm-" + newtoken + "@" + mailproc.hubShortURL
					)

			db.close()
			mailproc.log("processgroupforumpost.py end")

	exit(0)

except Exception, ex:
	exceptionMsg = "\nException Encountered:\n" + str(ex) + "\n" + traceback.format_exc()

	# strip newlines from output, the exim4 will log transport process errors, but only one line,
	# probably to keep logs pretty, who knows? We want everything there.
	# Replace them with literal \n, we can parse error manually when something breaks
	exceptionMsgNewlinesStripped = string.replace(exceptionMsg, "\n", "\\n")
	mailproc.log(exceptionMsgNewlinesStripped)
	sys.stderr.write(exceptionMsgNewlinesStripped)
	exit(1)
finally:
	mailproc.closelog()


