/**
 * @package      hubzero-mw-session
 * @file         pixelflip/pixelflip.c
 * @author       Rick Kennell <kennell@purdue.edu>
 * @copyright    Copyright (c) 2005-2015 HUBzero Foundation, LLC.
 * @license      http://opensource.org/licenses/MIT MIT
 *
 * Copyright (c) 2005-2015 HUBzero Foundation, LLC.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * HUBzero is a registered trademark of HUBzero Foundation, LLC.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>

#define SZ 1
#define INTERVAL (5*60) /* five minutes */
//#define INTERVAL (1)

int main(int argc, char *argv[])
{
  Display *d;
  int s;
  int root;
  int w;
  XSetWindowAttributes attrs;
  int mask;
  GC gc1, gc2;
  XGCValues gcvals;
  Colormap cmap;
  XColor def;
  int grey;


  d = XOpenDisplay(NULL);
  if (d == NULL) {
    fprintf(stderr,"%s: Can't open display", argv[0]);
    exit(1);
  }

  s = DefaultScreen(d);
  root = RootWindow(d,s);

  attrs.override_redirect = True;
  mask = CWOverrideRedirect;
  w = XCreateWindow(d, root, 0, 0, SZ, SZ, 0, CopyFromParent, InputOutput,
                    CopyFromParent, mask, &attrs);

  gcvals.background = BlackPixel(d,s);
  gcvals.foreground = WhitePixel(d,s);
  gcvals.fill_style = FillSolid;
  gc1 = XCreateGC(d,w,GCFillStyle|GCForeground|GCBackground,&gcvals);

  cmap = DefaultColormap(d,s);
  XParseColor(d, cmap, "#c0c0c0", &def);
  XAllocColor(d, cmap, &def);
  grey = def.pixel;

  gcvals.background = BlackPixel(d,s);
  gcvals.foreground = grey;
  gcvals.fill_style = FillSolid;
  gc2 = XCreateGC(d,w,GCFillStyle|GCForeground|GCBackground,&gcvals);

  daemon(0,0);

  while(1) {
    XMapRaised(d,w);
    XFillRectangle(d,w,gc1,0,0,SZ,SZ);
    XFlush(d);
    sleep(1);
    XFillRectangle(d,w,gc2,0,0,SZ,SZ);
    XFlush(d);
    sleep(1);
    XUnmapWindow(d,w);
    XFlush(d);
    sleep(INTERVAL);
  }

  return 0;
}

