/**
 * @file       config.h
 * @copyright  Copyright (c) 2016-2020 The Regents of the University of California.
 * @license    http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
 *
 * Copyright (c) 2016-2020 The Regents of the University of California.
 *
 * This file is part of: The HUBzero(R) Platform for Scientific Collaboration
 *
 * The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
 * software: you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * HUBzero is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * HUBzero is a registered trademark of The Regents of the University of California.
 */

#ifndef __CONFIG_H__
#define __CONFIG_H__

#include <stdint.h>
#include <limits.h>
#include "path.h"

/* LDAP prefix for project group membership */
#define REPO_PREFIX "pr-"
#define REPO_PREFIX_LEN 3

/* These are defaults, and can be overriden with command line options */
#define SRC_DIR "/srv/projects"
#define LOG_FILE "/var/log/projfs/projfs.log"

#ifdef IRODS_BUILD
  /* This causes xmp_link to perform a copy instead of calling the link() system
   * call. IRODs does not presently support hardlinks, so this is a kludge to get
   * around that. Turns out WinSCP uses link heavily.
   */
  #define IRODS_LINK
#else 
  /* This causes file operations to occur on a "shadow" copy of the file, with
   * the shadow file being moved to the actual file on close. It's primarily used
   * to avoid contention with other interfaces to the same data (eg, with
   * HUBzero's CMS interface to projects and the Google Drive extension, etc).
   */
//  #define SHADOW_WRITES
  
  /* This turns on locking. A directory (.lock42) is created prior to any
   * modifications to the project's directory structure. Motivation same as
   * SHADOW_WRITES. This serializes git operations.
   */
//  #define LOCKING
  
  /* Final piece of the puzzle, this causes the FUSE driver to invoke git when
   * appropriate, allowing revision tracking of modifications to project files.
   */
//  #define USE_GIT
#endif // IRODS_BUILD

#define GIT_TRACK_MAX 524288000 // 500MB
//#define GIT_LOG "/var/log/projfs/projfs.git"
#define GIT_LOG "/dev/null"

/* This enables verbose debugging output */
//#define DEBUG
//#define DEBUG_ARGS

/* Number of times to attempt to obtain a lock before bailing out */
#define LOCK_ATTEMPTS 5

#endif // __CONFIG_H__

