/**
 * @file       path.h
 * @copyright  Copyright (c) 2016-2020 The Regents of the University of California.
 * @license    http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
 *
 * Copyright (c) 2016-2020 The Regents of the University of California.
 *
 * This file is part of: The HUBzero(R) Platform for Scientific Collaboration
 *
 * The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
 * software: you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * HUBzero is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * HUBzero is a registered trademark of The Regents of the University of California.
 */

#ifndef __PATH_H__
#define __PATH_H__

#include <sys/types.h>
#include "config.h"

#define ACC_OK           0
#define ACC_NONE        -1
#define ACC_BLACKLISTED -2

#define BL_FREE   1
#define BL_NOFREE 0

typedef struct path_type_t {
  char *full_path; // Absolute path starting with source_dir
  char *file_name; // Part of path following final /
  char *repo_name; // Name of repository (no /'s)
  char *file_path; // File path relative to repository root
} path_t;

typedef struct path_list_type_t {
  path_t *path;
#ifdef SHADOW_WRITES
  char *tmp_path;  // Shadow file
#endif
  uid_t uid;
  int fd;
  struct path_list_type_t *next;
} path_list_t;

void dump_open_files(void);

void free_path(path_t *path);
void free_path_list(path_list_t *p);
path_t *dup_path(path_t *path);
path_t *normalize_path(const char *path);
int can_access(const char *path, path_t **normal_path, int);
int copy_file(const char *src, const char *dst);

#endif // __PATH_H__

