import os, ConfigParser, re, MySQLdb, string

class Hubzero_Database:
  def __init__(self, config = None):
    self.config(config)

  def config(self, config = None):
    if config:
      self.host = config.getJoomlaConfigParam('host')
      self.user = config.getJoomlaConfigParam('user')
      self.password = config.getJoomlaConfigParam('password')
      self.database = config.getJoomlaConfigParam('db')
      self.prefix = config.getJoomlaConfigParam('dbprefix')
    else:
      self.config = None
      self.host = None
      self.user = None
      self.password = None
      self.database = None
      self.prefix = None

  # connect() should handle all parameters legal to MySQLdb.connect and pass them along
  # but for now we keep it simple

  def connect(self):
    return MySQLdb.connect(host=self.host, user=self.user, passwd=self.password, db=self.database)

class Hubzero_Config:
  def __init__(self, name='default'):
    self.data = { 'component':{}, 'plugin':{}, 'module':{} }
    self.db = None

    try:
      if (name[0] == '/'):
        documentroot = name
      else:
        config = ConfigParser.RawConfigParser()
        config.read('/etc/hubzero.conf')
        site = config.get('default','site')
        documentroot = config.get(site,'DocumentRoot')
      self.data['DocumentRoot'] = documentroot
    except:
      pass

  def __connect(self):
    try:
      if not self.db:
        hzdb = Hubzero_Database(self)
        self.db = hzdb.connect()
    except:
      pass

  def __readJoomlaConfig(self):
    self.data['joomla'] = {}

    try:
      jconfig = open(self.data['DocumentRoot'] + '/configuration.php')
      contents = jconfig.read()
      jconfig.close()
      for m in re.finditer("\s*var\s+\$([a-zA-Z-_0-9]+)\s*=\s*(.+)\s*;", contents):
        self.data['joomla'][m.group(1)] = m.group(2).strip(" \'\"\t")
    except:
      pass

  def __readHubzeroConfig(self):
    self.data['hubzero'] = {}

    try:
      hconfig = open(self.data['DocumentRoot'] + '/hubconfiguration.php')
      contents = hconfig.read()
      hconfig.close()
      for m in re.finditer("\s*var\s+\$([a-zA-Z-_0-9]+)\s*=\s*(.+)\s*;", contents):
        self.data['hubzero'][m.group(1)] = m.group(2).strip(" \'\"\t")
    except:
      pass

  def __readComponent(self,component):
    self.data['component'][component] = {}

    try:
      self.__connect()
      cursor = self.db.cursor();
      cursor.execute("SELECT params FROM jos_components WHERE parent=0 AND `option`='com_" + component + "';")
      (result,) = cursor.fetchone()
      list = string.split(result)
      for l in list:
        kv = string.split(l,'=')
        self.data['component'][component][kv[0]] = kv[1]
    except:
      pass

  def __readModule(self,title):
    self.data['module'][title] = {}

    try:
      self.__connect()
      cursor = self.db.cursor();
      cursor.execute("SELECT params FROM jos_modules WHERE client_id=0 AND `title`='" + title + "';")
      (result,) = cursor.fetchone()
      list = string.split(result)
      for l in list:
        kv = string.split(l,'=')
        self.data['module'][title][kv[0]] = kv[1]
    except:
      pass

  def __readPlugin(self,element,folder):
    self.data['plugin'][element+"+"+folder] = {}

    try:
      self.__connect()
      cursor = self.db.cursor();
      cursor.execute("SELECT params FROM jos_plugins WHERE `element`='" + element + "' AND `folder`='" + folder + "';")
      (result,) = cursor.fetchone()
      list = string.split(result)
      for l in list:
        kv = string.split(l,'=')
        self.data['plugin'][element + "+" + folder][kv[0]] = kv[1]
    except:
      pass

  def setHubzeroDatabase(self,db):
    self.db = db

  def getHubzeroDatabase(self):
    self.__connect()
    return self.db

  def getJoomlaConfigParam(self,key):
    if ('joomla' not in self.data):
      self.__readJoomlaConfig()

    try:
      return self.data['joomla'][key]
    except:
      return None

  def getHubzeroConfigParam(self,key):
    if ('hubzero' not in self.data):
      self.__readHubzeroConfig()

    try:
      return self.data['hubzero'][key]
    except:
      return None

  def getComponentParam(self,component,key):
    if (component not in self.data['component']):
      self.__readComponent(component)
    
    try:
      return self.data['component'][component][key]
    except:
      return None

  def getModuleParam(self,title,key):
    if (title not in self.data['module']):
      self.__readModule(title)

    try:
      return self.data['module'][title][key]
    except:
      return None

  def getPluginParam(self,element,folder,key):
    if (element+"+"+folder not in self.data['plugin']):
      self.__readPlugin(element,folder)

    try:
      return self.data['plugin'][element + "+" + folder][key]
    except:
      return None
