# @package      hubzero-python
# @file         misc.py
# @author       David Benham <dbenham@purdue.edu>
# @copyright    Copyright (c) 2012-2015 HUBzero Foundation, LLC.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2012-2015 HUBzero Foundation, LLC.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#

import os
import subprocess
import traceback
import platform


# TODO: once all references to JOOMLA_25 have been removed, this can go, but till then
# its best to leave it, I use it for conditional SQL statements in the python
# library and in hzcms. - DRB 2016.09.26.14.28.34

JOOMLA_25 = True

if os.path.exists("/usr/share/hubzero-cms-2.1.0/cms/index.php"):
    JOOMLA_25 = True
elif os.path.exists("/usr/share/hubzero-cms-2.0.0/cms/index.php"):
    JOOMLA_25 = True
elif os.path.exists("/usr/share/hubzero-cms-1.3.1/cms/index.php"):
    JOOMLA_25 = True
elif os.path.exists("/usr/share/hubzero-cms-1.3.0/cms/index.php"):
    JOOMLA_25 = True
elif os.path.exists("/usr/share/hubzero-cms-1.2.2/cms/index.php"):
    JOOMLA_25 = True
elif os.path.exists("/usr/share/hubzero-cms-1.2.1/cms/index.php"):
    JOOMLA_25 = True
elif os.path.exists("/usr/share/hubzero-cms-1.2.0/cms/index.php"):
    JOOMLA_25 = True
elif os.path.exists("/usr/share/hubzero-cms-1.1.0/cms/index.php"):
    JOOMLA_25 = False
elif os.path.exists("/usr/share/hubzero-cms/cms/index.php"):
    JOOMLA_25 = False
else:
    JOOMLA_25 = True


def isDebian():
	distname, version, id = platform.linux_distribution(full_distribution_name=False)
	return distname == 'debian'

	
def isRHEL():
	distname, version, id = platform.linux_distribution(full_distribution_name=False)
	return distname == 'redhat' or distname == 'centos'


def exShellCommand(argArray, processInput=''):
	""" Wrapper to run and return output of a shell command """
	
	try:
		proc = subprocess.Popen(argArray,
			                    shell=False,
			                    stdin=subprocess.PIPE,
			                    stdout=subprocess.PIPE,
			                    stderr=subprocess.PIPE)
	
		procStdOut, procStdErr = proc.communicate(processInput)
		rc = proc.returncode

	except Exception, ex:	
		raise Exception('exShellCommand error ' + str(argArray) + ' ' + str(ex) + "\n" + traceback.format_exc())

	return rc, procStdOut, procStdErr
