'\"
'\" Generated from file '../../runtime/tcllib-1.12/modules/jpeg/jpeg.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2004-2005, Code: Aaron Faupell <afaupell@users.sourceforge.net>
'\" Copyright (c) 2007, Code:  Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\" Copyright (c) 2004-2009, Doc:  Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "jpeg" n 0.3.5 jpeg "JPEG image manipulation"
.BS
.SH NAME
jpeg \- JPEG querying and manipulation of meta data
.SH SYNOPSIS
package require \fBTcl  8.2\fR
.sp
package require \fBjpeg  ?0.3.5?\fR
.sp
\fB::jpeg::isJPEG\fR \fIfile\fR
.sp
\fB::jpeg::imageInfo\fR \fIfile\fR
.sp
\fB::jpeg::dimensions\fR \fIfile\fR
.sp
\fB::jpeg::getThumbnail\fR \fIfile\fR
.sp
\fB::jpeg::getExif\fR \fIfile\fR ?\fIsection\fR?
.sp
\fB::jpeg::formatExif\fR \fIkeys\fR
.sp
\fB::jpeg::exifKeys\fR
.sp
\fB::jpeg::removeExif\fR \fIfile\fR
.sp
\fB::jpeg::stripJPEG\fR \fIfile\fR
.sp
\fB::jpeg::getComments\fR \fIfile\fR
.sp
\fB::jpeg::addComment\fR \fIfile\fR \fItext\fR...
.sp
\fB::jpeg::removeComments\fR \fIfile\fR
.sp
\fB::jpeg::replaceComment\fR \fIfile\fR \fItext\fR
.sp
\fB::jpeg::debug\fR \fIfile\fR
.sp
\fB::jpeg::markers\fR \fIchannel\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides commands to query and modify JPEG images. JPEG
stands for \fIJoint Photography Experts Group\fR and is a standard
for the lossy compression of photographical images. It is specified at
\fILINK_HERE\fR.
.SH COMMANDS
.TP
\fB::jpeg::isJPEG\fR \fIfile\fR
Returns a boolean value indicating if \fIfile\fR is a
JPEG image.
.TP
\fB::jpeg::imageInfo\fR \fIfile\fR
Returns a dictionary with keys \fBversion\fR, \fBunits\fR,
\fBxdensity\fR, \fBydensity\fR, \fBxthumb\fR, and
\fBythumb\fR. The values are the associated properties of the JPEG
image in \fIfile\fR.
Throws an error if \fIfile\fR is not a JPEG image.
.TP
\fB::jpeg::dimensions\fR \fIfile\fR
Returns the dimensions of the JPEG \fIfile\fR as a list of the
horizontal and vertical pixel count.
Throws an error if \fIfile\fR is not a JPEG image.
.TP
\fB::jpeg::getThumbnail\fR \fIfile\fR
This procedure will return the binary thumbnail image data, if a JPEG
thumbnail is included in \fIfile\fR, and the empty string
otherwise. Note that it is possible to include thumbnails in formats
other than JPEG although that is not common. The command finds
thumbnails that are encoded in either the JFXX or EXIF segments of the
JPEG information. If both are present the EXIF thumbnail will take precedence.
Throws an error if \fIfile\fR is not a JPEG image.
.nf

    set fh [open thumbnail.jpg w+]
    fconfigure $fh -translation binary -encoding binary
    puts -nonewline $fh [::jpeg::getThumbnail photo.jpg]
    close $fh

.fi
.TP
\fB::jpeg::getExif\fR \fIfile\fR ?\fIsection\fR?
\fIsection\fR must be one of \fBmain\fR or \fBthumbnail\fR.
The default is \fBmain\fR.
Returns a dictionary containing the EXIF information for the specified section.
For example:
.sp
.nf

    set exif {
	Make     Canon
	Model    {Canon DIGITAL IXUS}
	DateTime {2001:06:09 15:17:32}
    }

.fi
Throws an error if \fIfile\fR is not a JPEG image.
.TP
\fB::jpeg::formatExif\fR \fIkeys\fR
Takes a list of key-value pairs as returned by \fBgetExif\fR and formats
many of the values into a more human readable form. As few as one key-value
may be passed in, the entire exif is not required.
.nf

    foreach {key val} [::jpeg::formatExif [::jpeg::getExif photo.jpg]] {
        puts "$key: $val"
    }

.fi
.sp
.nf

    array set exif [::jpeg::getExif photo.jpg]
    puts "max f-stop: [::jpeg::formatExif [list MaxAperture $exif(MaxAperture)]]

.fi
.TP
\fB::jpeg::exifKeys\fR
Returns a list of the EXIF keys which are currently understood.
There may be keys present in \fBgetExif\fR data that are not understood.
Those keys will appear in a 4 digit hexadecimal format.
.TP
\fB::jpeg::removeExif\fR \fIfile\fR
Removes the Exif data segment from the specified file and replaces
it with a standard JFIF segment.
Throws an error if \fIfile\fR is not a JPEG image.
.TP
\fB::jpeg::stripJPEG\fR \fIfile\fR
Removes all metadata from the JPEG file leaving only
the image. This includes comments, EXIF segments, JFXX
segments, and application specific segments.
Throws an error if \fIfile\fR is not a JPEG image.
.TP
\fB::jpeg::getComments\fR \fIfile\fR
Returns a list containing all the JPEG comments found in
the \fIfile\fR.
Throws an error if \fIfile\fR is not a valid JPEG image.
.TP
\fB::jpeg::addComment\fR \fIfile\fR \fItext\fR...
Adds one or more plain \fItext\fR comments to the JPEG image
in \fIfile\fR.
Throws an error if \fIfile\fR is not a valid JPEG image.
.TP
\fB::jpeg::removeComments\fR \fIfile\fR
Removes all comments from the file specified.
Throws an error if \fIfile\fR is not a valid JPEG image.
.TP
\fB::jpeg::replaceComment\fR \fIfile\fR \fItext\fR
Replaces the first comment in the file with the new \fItext\fR.
This is merely a shortcut for \fB::jpeg::removeComments\fR
and \fB::jpeg::addComment\fR
Throws an error if \fIfile\fR is not a valid JPEG image.
.TP
\fB::jpeg::debug\fR \fIfile\fR
Prints everything we know about the given file in a nice format.
.TP
\fB::jpeg::markers\fR \fIchannel\fR
This is an internal helper command, we document it for use by advanced
users of the package. The argument \fIchannel\fR is an open file
handle positioned at the start of the first marker (usually 2
bytes). The command returns a list with one element for each JFIF
marker found in the file. Each element consists of a list of the
marker name, its offset in the file, and its length. The offset points
to the beginning of the sections data, not the marker itself.  The
length is the length of the data from the offset listed to the start
of the next marker.
.PP
.SH LIMITATIONS
can only work with files
cant write exif data
gps exif data not parsed
makernote data not yet implemented
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIjpeg\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
comment, exif, image, jfif, jpeg, thumbnail
.SH CATEGORY
File formats
.SH COPYRIGHT
.nf
Copyright (c) 2004-2005, Code: Aaron Faupell <afaupell@users.sourceforge.net>
Copyright (c) 2007, Code:  Andreas Kupries <andreas_kupries@users.sourceforge.net>
Copyright (c) 2004-2009, Doc:  Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi