/*
 * ======================================================================
 *  Copyright (c) 2004-2005  Purdue Research Foundation
 *
 *  See the file "license.terms" for information on usage and
 *  redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * ======================================================================
 */

#ifdef __cplusplus
extern "C" {
#endif

double invert (double inVal);

double deci2base (double deci);
double centi2base (double centi);
double milli2base (double milli);
double micro2base (double micro);
double nano2base (double nano);
double pico2base (double pico);
double femto2base (double femto);
double atto2base (double atto);

double deca2base (double deca);
double hecto2base (double hecto);
double kilo2base (double kilo);
double mega2base (double mega);
double giga2base (double giga);
double tera2base (double tera);
double peta2base (double peta);
double exa2base (double exa);



double base2deci (double base);
double base2centi (double base);
double base2milli (double base);
double base2micro (double base);
double base2nano (double base);
double base2pico (double base);
double base2femto (double base);
double base2atto (double base);

double base2deca (double base);
double base2hecto (double base);
double base2kilo (double base);
double base2mega (double base);
double base2giga (double base);
double base2tera (double base);
double base2peta (double base);
double base2exa (double base);



double angstrom2meter (double angstrom);
double meter2angstrom (double meter);
double bohr2meter (double bohr);
double meter2bohr (double meter);
double meter2inch (double meter);
double inch2meter (double inch);
double inch2feet (double inch);
double feet2inch (double ft);
double inch2yard (double inch);
double yard2inch (double yd);
double inch2mile (double inch);
double mile2inch (double yd);




double fahrenheit2centigrade (double F);
double centigrade2fahrenheit (double C);
double centigrade2kelvin (double C);
double kelvin2centigrade (double K);
double rankine2kelvin (double R);
double kelvin2rankine (double K);
double fahrenheit2kelvin (double F);
double kelvin2fahrenheit (double K);
double fahrenheit2rankine (double F);
double rankine2fahrenheit (double R);
double rankine2celcius (double R);
double celcius2rankine (double C);



double electronVolt2joule (double eV);
double joule2electronVolt (double J);




double cubicMeter2usGallon (double m3);
double usGallon2cubicMeter (double gal);
double cubicFeet2usGallon (double ft3);
double usGallon2cubicFeet (double gal);
double cubicMeter2liter (double m3);
double liter2cubicMeter (double L);


double rad2deg  (double rad);
double deg2rad  (double deg);
double rad2grad (double rad);
double grad2rad (double grad);
double deg2grad (double deg);
double grad2deg (double grad);



double sec2min    (double sec);
double min2sec    (double min);
double sec2hour   (double sec);
double hour2sec   (double hour);
double sec2day (double sec);
double day2sec (double day);




double bar2Pa (double bar);
double Pa2bar (double Pa);
double bar2atm (double bar);
double atm2bar (double atm);
double bar2torr (double bar);
double torr2bar (double torr);
double bar2psi (double bar);
double psi2bar (double psi);
double Pa2atm (double Pa);
double atm2Pa (double atm);
double Pa2torr (double Pa);
double torr2Pa (double torr);
double Pa2psi (double Pa);
double psi2Pa (double psi);
double torr2atm (double torr);
double atm2torr (double atm);
double torr2psi (double torr);
double psi2torr (double psi);
double torr2mmHg (double torr);
double mmHg2torr (double mmHg);
double psi2atm (double psi);
double atm2psi (double atm);



double pH2pOH (double pH);
double pOH2pH (double pOH);



double tesla2gauss (double tesla);
double gauss2tesla (double gauss);
double maxwell2weber (double maxwell);
double weber2maxwell (double weber);

#ifdef __cplusplus
}
#endif
