'\"
'\" Generated from file '../../runtime/tcllib-1.12/modules/uri/uri.man' by tcllib/doctools with format 'nroff'
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "uri" n 1.2.1 uri "Tcl Uniform Resource Identifier Management"
.BS
.SH NAME
uri \- URI utilities
.SH SYNOPSIS
package require \fBTcl  8.2\fR
.sp
package require \fBuri  ?1.2.1?\fR
.sp
\fBuri::split\fR \fIurl\fR ?\fIdefaultscheme\fR?
.sp
\fBuri::join\fR ?\fIkey\fR \fIvalue\fR?...
.sp
\fBuri::resolve\fR \fIbase\fR \fIurl\fR
.sp
\fBuri::isrelative\fR \fIurl\fR
.sp
\fBuri::geturl\fR \fIurl\fR ?\fIoptions\fR...?
.sp
\fBuri::canonicalize\fR \fIuri\fR
.sp
\fBuri::register\fR \fIschemeList\fR \fIscript\fR
.sp
.BE
.SH DESCRIPTION
This package contains two parts. First it provides regular expressions
for a number of url/uri schemes. Second it provides a number of
commands for manipulating urls/uris and fetching data specified by
them. For the latter this package analyses the requested url/uri and
then dispatches it to the appropriate package (http, ftp, ...) for
actual fetching.
.PP
The package currently does not conform to
RFC 2396 (\fIhttp://www.rfc-editor.org/rfc/rfc2396.txt\fR),
but quite likely should be. Patches and other help are welcome.
.SH COMMANDS
.TP
\fBuri::split\fR \fIurl\fR ?\fIdefaultscheme\fR?
\fBuri::split\fR takes an \fIurl\fR, decodes it and then returns a
list of key/value pairs suitable for \fBarray set\fR containing the
constituents of the \fIurl\fR. If the scheme is missing from the url
it defaults to the value of \fIdefaultscheme\fR if it was specified,
or \fIhttp\fR else. Currently only the schemes \fIhttp\fR,
\fIftp\fR, \fImailto\fR, \fIurn\fR, \fInews\fR, \fIldap\fR and
\fIfile\fR are supported by the package itself.
See section \fBEXTENDING\fR on how to expand that range.
.sp
The set of constituents of an url (= the set of keys in the returned
dictionary) is dependent on the scheme of the url. The only key which
is therefore always present is \fBscheme\fR. For the following
schemes the constituents and their keys are known:
.RS
.TP
ftp
\fBuser\fR, \fBpwd\fR, \fBhost\fR, \fBport\fR,
\fBpath\fR, \fBtype\fR
.TP
http(s)
\fBuser\fR, \fBpwd\fR, \fBhost\fR, \fBport\fR,
\fBpath\fR, \fBquery\fR, \fBfragment\fR. The fragment
is optional.
.TP
file
\fBpath\fR, \fBhost\fR. The host is optional.
.TP
mailto
\fBuser\fR, \fBhost\fR. The host is optional.
.TP
news
Either \fBmessage-id\fR or \fBnewsgroup-name\fR.
.RE
.sp
.TP
\fBuri::join\fR ?\fIkey\fR \fIvalue\fR?...
\fBuri::join\fR takes a list of key/value pairs (generated by
\fBuri::split\fR, for example) and returns the canonical url they
represent. Currently only the schemes \fIhttp\fR, \fIftp\fR,
\fImailto\fR, \fIurn\fR, \fInews\fR, \fIldap\fR and \fIfile\fR
are supported. See section \fBEXTENDING\fR on how to expand that
range.
.TP
\fBuri::resolve\fR \fIbase\fR \fIurl\fR
\fBuri::resolve\fR resolves the specified \fIurl\fR relative to
\fIbase\fR. In other words: A non-relative \fIurl\fR is returned
unchanged, whereas for a relative \fIurl\fR the missing parts are
taken from \fIbase\fR and prepended to it. The result of this
operation is returned. For an empty \fIurl\fR the result is
\fIbase\fR.
.TP
\fBuri::isrelative\fR \fIurl\fR
\fBuri::isrelative\fR determines whether the specified \fIurl\fR is
absolute or relative.
.TP
\fBuri::geturl\fR \fIurl\fR ?\fIoptions\fR...?
\fBuri::geturl\fR decodes the specified \fIurl\fR and then dispatches
the request to the package appropriate for the scheme found in the
url. The command assumes that the package to handle the given scheme
either has the same name as the scheme itself (including possible
capitalization) followed by \fB::geturl\fR, or, in case of this
failing, has the same name as the scheme itself (including possible
capitalization). It further assumes that whatever package was loaded
provides a \fBgeturl\fR-command in the namespace of the same name as
the package itself. This command is called with the given \fIurl\fR
and all given \fIoptions\fR. Currently \fBgeturl\fR does not handle
any options itself.
.sp
\fINote:\fR \fIfile\fR-urls are an exception to the rule
described above. They are handled internally.
.sp
It is not possible to specify results of the command. They depend on
the \fBgeturl\fR-command for the scheme the request was dispatched to.
.TP
\fBuri::canonicalize\fR \fIuri\fR
\fBuri::canonicalize\fR returns the canonical form of a URI.  The
canonical form of a URI is one where relative path specifications,
ie. . and .., have been resolved.
.TP
\fBuri::register\fR \fIschemeList\fR \fIscript\fR
\fBuri::register\fR registers the first element of \fIschemeList\fR as
a new scheme and the remaining elements as aliases for this scheme. It
creates the namespace for the scheme and executes the \fIscript\fR in
the new namespace. The script has to declare variables containing the
regular expressions relevant to the scheme. At least the variable
\fBschemepart\fR has to be declared as that one is used to extend
the variables keeping track of the registered schemes.
.PP
.SH SCHEMES
In addition to the commands mentioned above this package provides
regular expression to recognize urls for a number of url schemes.
.PP
For each supported scheme a namespace of the same name as the scheme
itself is provided inside of the namespace \fIuri\fR containing the
variable \fBurl\fR whose contents are a regular expression to
recognize urls of that scheme. Additional variables may contain
regular expressions for parts of urls for that scheme.
.PP
The variable \fBuri::schemes\fR contains a list of all supported
schemes. Currently these are \fIftp\fR, \fIldap\fR, \fIfile\fR,
\fIhttp\fR, \fIgopher\fR, \fImailto\fR, \fInews\fR,
\fIwais\fR and \fIprospero\fR.
.SH EXTENDING
Extending the range of schemes supported by \fBuri::split\fR and
\fBuri::join\fR is easy because both commands do not handle the
request by themselves but dispatch it to another command in the
\fIuri\fR namespace using the scheme of the url as criterion.
.PP
\fBuri::split\fR and \fBuri::join\fR
call \fBSplit[string totitle <scheme>]\fR
and  \fBJoin[string totitle <scheme>]\fR respectively.
.SH CREDITS
.PP
Original code (regular expressions) by Andreas Kupries.
Modularisation by Steve Ball, also the split/join/resolve
functionality.
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIuri\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
fetching information, file, ftp, gopher, http, ldap, mailto, news, prospero, rfc 2255, rfc 2396, uri, url, wais, www
.SH CATEGORY
Networking