# @package      hubzero-submit-client
# @file         Probe.py
# @copyright    Copyright (c) 2012-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2012-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
class Probe:
   def __init__(self,
                id,
                when,
                destination):
      self.id          = id
      self.when        = when
      self.destination = destination
      self.jobStarted  = 0
      self.jobFinished = 0
      self.exitStatus  = 0


   def show(self):
      return("%d %ld %s %ld %ld %d" % (self.id,self.when,self.destination,self.jobStarted,self.jobFinished,self.exitStatus))


   def dump(self,
            fpDumpFile):
      try:
         fpDumpFile.write(self.show() + '\n')
         fpDumpFile.flush()
      except:
         pass


   def read(self,
            fp):
      record = fp.readline()
      if record != "":
         id,when,destination,jobStarted,jobFinished,exitStatus = record.split()
         self.id          = int(id)
         self.when        = float(when)
         self.destination = destination
         self.jobStarted  = float(jobStarted)
         self.jobFinished = float(jobFinished)
         self.exitStatus  = int(exitStatus)


   def __cmp__(self,
               other): 
      if self.when < other.when: return(-1)
      if self.when > other.when: return( 1)
      return(0)


   def __lt__(self,
              other): 
      return(self.when < other.when)


   def __gt__(self,
              other): 
      return(self.when > other.when)


   def __le__(self,
              other): 
      return(self.when <= other.when)


   def __ge__(self,
              other): 
      return(self.when >= other.when)


   def __eq__(self,
              other): 
      return(self.when == other.when)


   def __ne__(self,
              other): 
      return(self.when != other.when)


