# @package      hubzero-submit-common
# @file         TimeConversion.py
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2012-2013 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2012-2013 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#

def hhmmssTomin(hhmmss):
   parts = hhmmss.split(':')
   parts.reverse()
   if len(parts) == 1:
      minutes = float(hhmmss)
   else:
      minutes = float(parts[0])/60.
      factor = 1
      for partId in xrange(1,min(len(parts),3)):
         minutes += factor*float(parts[partId])
         factor *= 60

   return(minutes)


def minTohhmmss(mins):
   seconds = (float(mins)-int(float(mins)))*60.
   hours   = int(float(mins)) / 60
   minutes = int(float(mins)) % 60
   hhmmss  = "%0.2d:%0.2d:%0.2d" % (hours,minutes,seconds)

   return(hhmmss)


