# @package      hubzero-submit-common
# @file         JobStatistic.py
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2012-2013 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2012-2013 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#

import os
import os.path
import re
from UserDict import UserDict

class JobStatistic(UserDict):
   def __init__(self,
                nCores):
      UserDict.__init__(self)
      self['jobSubmissionMechanism'] = 'Unknown'
      self['remoteJobIdNumber']      = ''
      self['event']                  = ''
      self['venue']                  = ''
      self['realTime']               = 0.
      self['userTime']               = 0.
      self['sysTime']                = 0.
      self['exitCode']               = 2
      self['transferCompleteTime']   = 0.
      self['jobStartedTime']         = 0.
      self['jobFinshedTime']         = 0.
      self['waitingTime']            = 0.
      self['elapsedRunTime']         = 0.
      self['nCores']                 = nCores


   def recordTime(self,
                  statistic,
                  timePath):
      if os.path.exists(timePath):
         if(os.path.getsize(timePath)):
            fpTime = open(timePath,'r')
            if fpTime:
               self[statistic] = float(fpTime.readline())
               fpTime.close()
         os.remove(timePath)


   def recordTimer(self,
                   timerPath):
      if os.path.exists(timerPath):
         venue       = None
         jobId       = None
         event       = None
         realTime    = 0.
         userTime    = 0.
         sysTime     = 0.
         elapsedTime = 0.
         waitTime    = 0.
         exitStatus  = 0
         exitSignal  = 0

         fpTimer = open(timerPath,'r')
         if fpTimer:
            while True:
               line = fpTimer.readline()
               if not line:
                  break
               line = line.strip()

               if line != "":
                  parts = line.split()
                  if len(parts) == 2:
                     timeType = parts[0]
                     try:
                        timeUsed = float(parts[1])

                        if   timeType == 'real':
                           realTime    = max(realTime,timeUsed)
                        elif timeType == 'user':
                           userTime    = userTime + timeUsed
                        elif timeType == 'sys':
                           sysTime     = sysTime + timeUsed
                        elif timeType == 'elapsed':
                           elapsedTime = elapsedTime + timeUsed
                        elif timeType == 'wait':
                           waitTime    = waitTime + timeUsed
                        elif timeType == 'jobId':
                           jobId       = parts[1]
                     except:
                        if   timeType == 'site':
                           venue = parts[1]
                        elif timeType == 'jobId':
                           jobId = parts[1]
                        elif timeType == 'event':
                           event = parts[1]
                  else:
                     if len(parts) > 2:
                        if parts[-2] == "status":
                           exitStatus = int(float(parts[-1]))
                        if parts[-2] == "signal":
   # Killed by signal 2.
                           exitStatus = 1
                           exitSignal = int(float(parts[-1]))
                     if re.search("Killed",line):
                        exitStatus = 1
                        exitSignal = 15

            fpTimer.close()

            if exitSignal > 0:
               self['exitCode']    = exitStatus << 8 | exitSignal
            else:
               self['exitCode']    = exitStatus
            self['realTime']       = realTime
            self['userTime']       = userTime
            self['sysTime']        = sysTime
            self['elapsedRunTime'] = elapsedTime
            self['waitingTime']    = waitTime
            if venue and not self['venue']:
               self['venue']             = venue
            if jobId:
               self['remoteJobIdNumber'] = jobId
            if event:
               self['event']             = event

         os.remove(timerPath)


   def setWaitingTime(self):
      waitingTime = self['jobStartedTime'] - self['transferCompleteTime']
      self['waitingTime'] += max(waitingTime,0.)


   def setElapsedRunTime(self):
      elapsedRunTime = self['jobFinshedTime'] - self['jobStartedTime']
      self['elapsedRunTime'] = max(self['elapsedRunTime'],elapsedRunTime)


