# @package      hubzero-submit-common
# @file         TimeConversion.py
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2012-2015 HUBzero Foundation, LLC.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2012-2015 HUBzero Foundation, LLC.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
def hhmmssTomin(hhmmss):
   parts = hhmmss.split(':')
   parts.reverse()
   if len(parts) == 1:
      minutes = float(hhmmss)
   else:
      minutes = float(parts[0])/60.
      factor = 1
      for partId in xrange(1,min(len(parts),3)):
         minutes += factor*float(parts[partId])
         factor *= 60

   return(minutes)


def minTohhmmss(mins):
   seconds = (float(mins)-int(float(mins)))*60.
   hours   = int(float(mins)) / 60
   minutes = int(float(mins)) % 60
   hhmmss  = "%0.2d:%0.2d:%0.2d" % (hours,minutes,seconds)

   return(hhmmss)


