#
# Copyright (c) 2004-2010 Purdue University All rights reserved.
# 
# Developed by: HUBzero Technology Group, Purdue University
#               http://hubzero.org
# 
# HUBzero is free software: you can redistribute it and/or modify it under the terms of the
# GNU Lesser General Public License as published by the Free Software Foundation, either
# version 3 of the License, or (at your option) any later version.
# 
# HUBzero is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
# without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU Lesser General Public License for more details.  You should have received a
# copy of the GNU Lesser General Public License along with HUBzero.
# If not, see <http://www.gnu.org/licenses/>.
# 
# GNU LESSER GENERAL PUBLIC LICENSE
# Version 3, 29 June 2007
# Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>
#
import os.path
import re

from LogMessage import log as log

class ManagersInfo:
   def __init__(self,
                infoDirectory,
                managersFile):
      self.managers = {}

      managerPattern  = re.compile('(.*\[)(.*)(])')
      keyValuePattern = re.compile('( *)(\w*)( *= *)(.*[^\s$])( *)')
      commentPattern  = re.compile('\s*#.*')
      managerName     = ""

      fp = open(os.path.join(infoDirectory,managersFile), "r")
      if fp:
         eof = False
         while not eof:
            record = fp.readline()
            if record != "":
               record = commentPattern.sub("",record)
               if   managerPattern.match(record):
                  managerName = managerPattern.match(record).group(2)
                  self.managers[managerName] = {'computationMode':'mpi', \
                                                'preManagerCommands':[], \
                                                'managerCommand':'', \
                                                'postManagerCommands':[], \
                                                'mpiRankVariable':'', \
                                                'environment':[], \
                                                'moduleInitialize':'', \
                                                'modulesLoad':[], \
                                                'modulesUnload':[]
                                               }
               elif keyValuePattern.match(record):
                  key,value = keyValuePattern.match(record).group(2,4)
                  if key in self.managers[managerName]:
                     if   isinstance(self.managers[managerName][key],list):
                        self.managers[managerName][key] = [e.strip() for e in value.split(',')]
                     elif isinstance(self.managers[managerName][key],bool):
                        self.managers[managerName][key] = bool(value.lower() == 'true')
                     else:
                        self.managers[managerName][key] = value
                  else:
                     log("Undefined key = value pair %s = %s for manager %s" % (key,value,managerName))
            else:
               eof = True
         fp.close()


   def getManagerNames(self):
      managerNames = []
      for managerName in self.managers:
         managerNames.append(managerName)

      return(managerNames)


   def getManagerInfo(self,
                      managerName):
      managerExists       = False
      computationMode     = 'mpi'
      preManagerCommands  = []
      managerCommand      = ''
      postManagerCommands = []
      mpiRankVariable     = ''
      environment         = []
      moduleInitialize    = ''
      modulesLoad         = []
      modulesUnload       = []

      if managerName in self.managers:
         managerExists          = True
         computationMode        = self.managers[managerName]['computationMode']
         if 'preManagerCommands' in self.managers[managerName]:
            preManagerCommands  = self.managers[managerName]['preManagerCommands']
         if 'managerCommand' in self.managers[managerName]:
            managerCommand      = self.managers[managerName]['managerCommand']
         if 'postManagerCommands' in self.managers[managerName]:
            postManagerCommands = self.managers[managerName]['postManagerCommands']
         if 'mpiRankVariable' in self.managers[managerName]:
            mpiRankVariable     = self.managers[managerName]['mpiRankVariable']
         if 'environment' in self.managers[managerName]:
            environment         = self.managers[managerName]['environment']
         if 'moduleInitialize' in self.managers[managerName]:
            moduleInitialize    = self.managers[managerName]['moduleInitialize']
         if 'modulesLoad' in self.managers[managerName]:
            modulesLoad         = self.managers[managerName]['modulesLoad']
         if 'modulesUnload' in self.managers[managerName]:
            modulesUnload       = self.managers[managerName]['modulesUnload']

      return(managerExists,computationMode, \
             preManagerCommands,managerCommand,postManagerCommands, \
             mpiRankVariable,environment,moduleInitialize,modulesLoad,modulesUnload)


