#
# Copyright (c) 2004-2010 Purdue University All rights reserved.
# 
# Developed by: HUBzero Technology Group, Purdue University
#               http://hubzero.org
# 
# HUBzero is free software: you can redistribute it and/or modify it under the terms of the
# GNU Lesser General Public License as published by the Free Software Foundation, either
# version 3 of the License, or (at your option) any later version.
# 
# HUBzero is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
# without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU Lesser General Public License for more details.  You should have received a
# copy of the GNU Lesser General Public License along with HUBzero.
# If not, see <http://www.gnu.org/licenses/>.
# 
# GNU LESSER GENERAL PUBLIC LICENSE
# Version 3, 29 June 2007
# Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>
#
import sys
import os
import time

logMessageFile = sys.stdout
logJOBID       = 0

def getLogMessageFileNo():
   return logMessageFile.fileno()


def openLog(logName):
   global logMessageFile

   try:
      logMessageFile = open(logName,"a")
   except:
      logMessageFile = sys.stdout


def log(message):
   global logMessageFile

   if message != "":
      logMessageFile.write("[%s] %s\n" % (time.ctime(),message))
      logMessageFile.flush()


def logPID(message):
   global logMessageFile

   if message != "":
      logMessageFile.write("[%s] (%d) %s\n" % (time.ctime(),os.getpid(),message))
      logMessageFile.flush()


def logSetJobId(jobId):
   global logJOBID

   logJOBID = jobId


def logJobId(message):
   global logMessageFile
   global logJOBID

   if message != "":
      logMessageFile.write("[%s] %d: %s\n" % (time.ctime(),logJOBID,message))
      logMessageFile.flush()


def logID(message):
   global logMessageFile
   global logJOBID

   if message != "":
      if logJOBID > 0:
         logJobId(message)
      else:
         logPID(message)


