#
# Copyright (c) 2004-2010 Purdue University All rights reserved.
# 
# Developed by: HUBzero Technology Group, Purdue University
#               http://hubzero.org
# 
# HUBzero is free software: you can redistribute it and/or modify it under the terms of the
# GNU Lesser General Public License as published by the Free Software Foundation, either
# version 3 of the License, or (at your option) any later version.
# 
# HUBzero is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
# without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU Lesser General Public License for more details.  You should have received a
# copy of the GNU Lesser General Public License along with HUBzero.
# If not, see <http://www.gnu.org/licenses/>.
# 
# GNU LESSER GENERAL PUBLIC LICENSE
# Version 3, 29 June 2007
# Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>
#
import os.path
import re

from LogMessage import logID as log

class MonitorsInfo:
   def __init__(self,
                infoDirectory,
                monitorsFile):
      self.monitors = {}

      monitorPattern  = re.compile('(.*\[)(.*)(])')
      keyValuePattern = re.compile('( *)(\w*)( *= *)(.*[^\s$])( *)')
      commentPattern  = re.compile('\s*#.*')
      monitorName     = ""

      fp = open(os.path.join(infoDirectory,monitorsFile), "r")
      if fp:
         eof = False
         while not eof:
            record = fp.readline()
            if record != "":
               record = commentPattern.sub("",record)
               if   monitorPattern.match(record):
                  monitorName = monitorPattern.match(record).group(2)
                  self.monitors[monitorName] = {'venue':'', \
                                                'tunnelDesignator':'', \
                                                'remoteUser':'', \
                                                'remoteMonitorCommand':'', \
                                               }
               elif keyValuePattern.match(record):
                  key,value = keyValuePattern.match(record).group(2,4)
                  if key in self.monitors[monitorName]:
                     if   isinstance(self.monitors[monitorName][key],list):
                        self.monitors[monitorName][key] = [e.strip() for e in value.split(',')]
                     elif isinstance(self.monitors[monitorName][key],bool):
                        self.monitors[monitorName][key] = bool(value.lower() == 'true')
                     else:
                        self.monitors[monitorName][key] = value
                  else:
                     log("Undefined key = value pair %s = %s for site %s" % (key,value,monitorName))
            else:
               eof = True
         fp.close()


   def getSSHCommand(self,
                     monitorName,
                     IDENTITY,
                     remoteTunnelMonitor):
      sshCommand       = ""
      tunnelDesignator = ""
      try:
         venue                = self.monitors[monitorName]['venue']
         tunnelDesignator     = self.monitors[monitorName]['tunnelDesignator']
         user                 = self.monitors[monitorName]['remoteUser']
         remoteMonitorCommand = self.monitors[monitorName]['remoteMonitorCommand']
         if tunnelDesignator == "":
            sshCommand = "ssh -T -x -a -i " + IDENTITY + " " + user + "@" + venue + " \"" + remoteMonitorCommand + "\""
         else:
            tunnelAddress,tunnelPort = remoteTunnelMonitor.getTunnelAddressPort(tunnelDesignator)
            sshCommand = "ssh -T -x -a -i " + IDENTITY + " -p " + tunnelPort + " " + user + "@" + tunnelAddress + " \"" + remoteMonitorCommand + "\""
      except:
         log("Build sshCommand failed for %s" % (monitorName))

      return(sshCommand,tunnelDesignator)


