#!/bin/sh
#
# Copyright (c) 2004-2010 Purdue University All rights reserved.
# 
# Developed by: HUBzero Technology Group, Purdue University
#               http://hubzero.org
# 
# HUBzero is free software: you can redistribute it and/or modify it under the terms of the
# GNU Lesser General Public License as published by the Free Software Foundation, either
# version 3 of the License, or (at your option) any later version.
# 
# HUBzero is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
# without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU Lesser General Public License for more details.  You should have received a
# copy of the GNU Lesser General Public License along with HUBzero.
# If not, see <http://www.gnu.org/licenses/>.
# 
# GNU LESSER GENERAL PUBLIC LICENSE
# Version 3, 29 June 2007
# Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>
#
cd $1
exitStatus=$?

if [ $exitStatus -eq 0 ] ; then
   case $2 in
      *.ll)
         JOB=`llsubmit $2`
         exitStatus=$?
#llsubmit: The job "fengpfs.79854" has been submitted.
         h=${JOB#*\"}
         JOBID=${h%%\"*}
         if [ $# -gt 2 ] ; then
            logRecord=`date`
            shift 2
            while [ $# -gt 0 ] ; do
               logRecord=${logRecord}'\t'$1
               shift 1
            done
            logRecord=${logRecord}'\t'${JOB}
            echo -e ${logRecord} >> lllog
         fi
         ;;
      *)
         echo "Invalid job class $2"
         exitStatus=23
         ;;
   esac
fi

if [ $exitStatus -eq 0 ] ; then
   echo ${JOBID}
else
   echo "-1"
fi

exit $exitStatus
