#
# @package      hubzero-submit-distributor
# @file         LogMessage.py
# @author       Steve Clark <clarks@purdue.edu>
# @copyright    Copyright 2004-2011 Purdue University. All rights reserved.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2004-2011 Purdue University
# All rights reserved.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of Purdue University.
#
import sys
import os
import time

LOGMESSAGEFILE = sys.stdout
LOGJOBID       = 0

def getLogMessageFileNo():
   global LOGMESSAGEFILE

   return LOGMESSAGEFILE.fileno()


def openLog(logName):
   global LOGMESSAGEFILE

   try:
      LOGMESSAGEFILE = open(logName,'a')
   except:
      LOGMESSAGEFILE = sys.stdout


def log(message):
   global LOGMESSAGEFILE

   if message != "":
      LOGMESSAGEFILE.write("[%s] %s\n" % (time.ctime(),message))
      LOGMESSAGEFILE.flush()


def logPID(message):
   global LOGMESSAGEFILE

   if message != "":
      LOGMESSAGEFILE.write("[%s] (%d) %s\n" % (time.ctime(),os.getpid(),message))
      LOGMESSAGEFILE.flush()


def logSetJobId(jobId):
   global LOGJOBID

   LOGJOBID = jobId


def logJobId(message):
   global LOGMESSAGEFILE
   global LOGJOBID

   if message != "":
      LOGMESSAGEFILE.write("[%s] %d: %s\n" % (time.ctime(),LOGJOBID,message))
      LOGMESSAGEFILE.flush()


def logID(message):
   global LOGJOBID

   if message != "":
      if LOGJOBID > 0:
         logJobId(message)
      else:
         logPID(message)

