#!/usr/bin/env python
#
# @package      hubzero-submit-distributor
# @file         monitorTunnelD.py
# @author       Steve Clark <clarks@purdue.edu>
# @copyright    Copyright 2004-2011 Purdue University. All rights reserved.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2004-2011 Purdue University
# All rights reserved.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of Purdue University.
#
# ----------------------------------------------------------------------
#  monitorTunnelD.py
#
#  script which decrements ssh tunnel use
#
import sys

from RemoteTunnelMonitor import RemoteTunnelMonitor

TUNNELMONITORHOST = ""
TUNNELMONITORPORT = 5729

def monitorTunnelD():
   """Decrement ssh tunnel use"""
   tunnelName = sys.argv[1]

   remoteTunnelMonitor = RemoteTunnelMonitor(TUNNELMONITORHOST,TUNNELMONITORPORT)

   useCount = remoteTunnelMonitor.decrementTunnelUse(tunnelName)
   print("%s %s" % (tunnelName,useCount))


if __name__ == '__main__':
   monitorTunnelD()

