#!/bin/sh
#
# @package      hubzero-submit-distributor
# @file         Scripts/condor/cleanupjob.sh
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright 2004-2012 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2004-2012 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
if [ $# -ne 1 ] ; then
   echo usage: $0 jobWorkingDirectory
   exit 64
fi

cd $1
exitStatus=$?

if [ $exitStatus -eq 0 ] ; then
   . /etc/environ.sh
   use -e -r pegasus-@PEGASUSVERSION@

   if [ -d work/pegasus ] ; then
      propertiesFile=$(ls work/pegasus/pegasus.[1-9]*.properties 2> /dev/null)
      if [ -n "${propertiesFile}" ] ; then
         pegasus-analyzer --dir=work/pegasus \
                          --conf=${propertiesFile} > pegasus.analysis 2>&1

         pegasus-statistics --conf=${propertiesFile} \
                            --statistics-level=jb_stats \
                            --quiet \
                            work/pegasus
         if [ -f work/pegasus/statistics/jobs.csv ] ; then
            mv work/pegasus/statistics/jobs.csv pegasusjobstats.csv
         fi
         if [ -f work/pegasus/statistics/jobs.txt ] ; then
            mv work/pegasus/statistics/jobs.txt pegasusjobstats.txt
         fi
      fi
      rm -rf scratch
   fi
fi

exit $exitStatus
