#!/usr/bin/python2.6
#
# @package      hubzero-submit-distributor
# @file         monitorJobS.py
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2004-2012 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2004-2012 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
# ----------------------------------------------------------------------
#  monitorJobS.py
#
#  script which notifies monitorJob.py of a new job submission
#
import sys

from hubzero.submit.RemoteJobMonitor import RemoteJobMonitor

JOBMONITORHOST = ""
JOBMONITORPORT = 5727

def monitorJobS():
   """new job Submission"""
   messageSite = sys.argv[1]
   remoteJobId = sys.argv[2]
   hubUserId   = sys.argv[3]
   localJobId  = sys.argv[4]
   destination = sys.argv[5]

   remoteJobMonitor = RemoteJobMonitor(JOBMONITORHOST,JOBMONITORPORT)

   remoteJobMonitor.postNewJobSubmission(messageSite,remoteJobId, \
                                         hubUserId,localJobId,destination)


if __name__ == '__main__':
   monitorJobS()


