#!/bin/sh
#
# @package      hubzero-submit-distributor
# @file         Scripts/condor/submitbatchjob.sh
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright 2004-2013 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2004-2013 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
if [ $# -lt 3 ] ; then
   echo usage: $0 jobWorkingDirectory jobScratchDirectory jobDescriptionFile
   exit 64
fi

jobWorkingDirectory=$1
jobScratchDirectory=$2
jobDescriptionFile=$3

binPath=$(readlink -f $(dirname $0))
export PATH=${binPath}:${PATH}

cd ${jobWorkingDirectory}
exitStatus=$?

if [ ${exitStatus} -eq 0 ] ; then
   case ${jobDescriptionFile} in
      *.condor)
         JOBID=`condor_submit ${jobDescriptionFile}`
         exitStatus=$?
         if [ $# -gt 3 ] ; then
            logRecord=`date`
            shift 3
            while [ $# -gt 0 ] ; do
               logRecord=${logRecord}'\t'$1
               shift 1
            done
            logRecord=${logRecord}'\t'${JOBID}
            echo -e ${logRecord} >> ${HOME}/condorlog
         fi
         ;;
      *.pegasus)
         if [ -x /local/proxy/bin/personalize-proxy.sh ] ; then
            /local/proxy/bin/personalize-proxy.sh
         fi
         JOBID=`${jobDescriptionFile}`
         exitStatus=$?
         if [ ${exitStatus} -eq 0 ] ; then
            nohup movepegtmp2home.sh ${jobWorkingDirectory} ${jobScratchDirectory} > /dev/null 2>&1 &
         fi
         ;;
      *)
         echo "Invalid job class ${jobDescriptionFile}"
         exitStatus=23
         ;;
   esac
fi

if [ ${exitStatus} -eq 0 ] ; then
   echo "${JOBID}"
else
   echo "-1"
fi

exit ${exitStatus}
