#!/usr/bin/env python
#
# @package      hubzero-submit-distributor
# @file         harvester.py
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2004-2015 HUBzero Foundation, LLC.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2004-2015 HUBzero Foundation, LLC.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
"""Harvest results at completion of distributed job."""

import os
import sys
import logging
from logging.handlers import SysLogHandler

from hubzero.submit.JobHarvester import JobHarvester

LOGDIRECTORY      = os.path.join(os.sep,'var','log','submit','distributor')
APPLICATIONLOGGER = logging.getLogger('')

CONFIGURATIONDIRECTORY       = os.path.join(os.sep,'etc','submit')
DISTRIBUTORCONFIGURATIONFILE = 'distributor.conf'
DAEMONSCONFIGURATIONFILE     = 'daemons.conf'
INFOSCONFIGURATIONFILE       = 'infos.conf'

def openLogger():
   class EmptyFilter(logging.Filter):
      """
      This is a filter which rejects empty messages

      """

      def filter(self,record):
         if record.getMessage() == "":
            emptyRecord = True
         else:
            emptyRecord = False

         return(not emptyRecord)

   APPLICATIONLOGGER.setLevel(logging.ERROR)

   logSyslogHandler = SysLogHandler(address="/dev/log",facility=SysLogHandler.LOG_LOCAL6)
   emptyFilter = EmptyFilter()
   logSyslogHandler.addFilter(emptyFilter)
   logFormatter = logging.Formatter('%(asctime)s %(message)s','%s [%a %b %d %H:%M:%S %Y]')
   logSyslogHandler.setFormatter(logFormatter)
   APPLICATIONLOGGER.addHandler(logSyslogHandler)


def harvester(configurationDirectory,
              distributorConfigurationFile,daemonsConfigurationFile,infosConfigurationFile):
   jobHarvester = JobHarvester(configurationDirectory,
                               distributorConfigurationFile,daemonsConfigurationFile,infosConfigurationFile)
   if jobHarvester.configure():
      exitCode = jobHarvester.processCommandArguments()
      if not exitCode:
         exitCode = jobHarvester.buildJobInstances()
         if not exitCode:
            exitCode = jobHarvester.harvestJobInstances()
      jobHarvester.reportExitCondition()
   else:
      exitCode = 1

   sys.exit(exitCode)


if __name__ == '__main__':
   openLogger()

   harvester(CONFIGURATIONDIRECTORY,
             DISTRIBUTORCONFIGURATIONFILE,DAEMONSCONFIGURATIONFILE,INFOSCONFIGURATIONFILE)


