# @package      hubzero-submit-distributor
# @file         RemoteCloudMonitor.py
# @copyright    Copyright (c) 2012-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2012-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
import time
import traceback
import logging

from hubzero.submit.LogMessage        import getLogIDMessage as getLogMessage
from hubzero.submit.MessageConnection import MessageConnection

class RemoteCloudMonitor(MessageConnection):
   def __init__(self,
                listenURI):
      MessageConnection.__init__(self,listenURI)

      self.logger = logging.getLogger(__name__)


   def createCloudInstance(self,
                           cloudName):
      instanceId = ""

      queryMessage = {'messageType':'createCloudInstance',
                      'cloudDesignator':cloudName}
      nTry,response = self.requestJsonExchange(queryMessage)

      if nTry > 1:
         self.logger.log(logging.WARNING,getLogMessage("confirmation: createCloudInstance(%d):%s" % \
                                                        (nTry,response['messageType'])))

      instanceId = response['instanceId']

      return(instanceId)


   def incrementCloudInstance(self,
                              cloudName,
                              instanceId,
                              jobId):
      instanceIncremented = False

      queryMessage = {'messageType':'incrementCloudInstanceUsage',
                      'cloudDesignator':cloudName,
                      'instanceId':instanceId,
                      'jobId':jobId}
      nTry,response = self.requestJsonExchange(queryMessage)

      if nTry > 1:
         self.logger.log(logging.WARNING,getLogMessage("confirmation: incrementCloudInstanceUsage(%d):%s" % \
                                                        (nTry,response['messageType'])))

      instanceIncremented = response['success']

      return(instanceIncremented)


   def decrementCloudInstance(self,
                              cloudName,
                              instanceId,
                              jobId):
      instanceDecremented = False

      queryMessage = {'messageType':'decrementCloudInstanceUsage',
                      'cloudDesignator':cloudName,
                      'instanceId':instanceId,
                      'jobId':jobId}
      nTry,response = self.requestJsonExchange(queryMessage)

      if nTry > 1:
         self.logger.log(logging.WARNING,getLogMessage("confirmation: decrementCloudInstanceUsage(%d):%s" % \
                                                        (nTry,response['messageType'])))

      instanceDecremented = response['success']

      return(instanceDecremented)


   def terminateCloudInstance(self,
                              cloudName,
                              instanceId):
      instanceTerminated = False

      queryMessage = {'messageType':'terminateCloudInstance',
                      'cloudDesignator':cloudName,
                      'instanceId':instanceId}
      nTry,response = self.requestJsonExchange(queryMessage)

      if nTry > 1:
         self.logger.log(logging.WARNING,getLogMessage("confirmation: terminateCloudInstance(%d):%s" % \
                                                        (nTry,response['messageType'])))

      instanceTerminated = response['success']

      return(instanceTerminated)


   def allocateCloudInstance(self,
                             cloudName,
                             jobId,
                             wallTime):
      instanceId = ""

      queryMessage = {'messageType':'allocateInstance',
                      'cloudDesignator':cloudName,
                      'jobId':jobId,
                      'wallTime':wallTime}
      nTry,response = self.requestJsonExchange(queryMessage)

      if nTry > 1:
         self.logger.log(logging.WARNING,getLogMessage("confirmation: allocateInstance(%d):%s" % \
                                                        (nTry,response['messageType'])))

      instanceId = response['instanceId']

      return(instanceId)


   def getCloudInstanceHostname(self,
                                cloudName,
                                instanceId):
      hostName = ""

      queryMessage = {'messageType':'getInstanceHostname',
                      'cloudDesignator':cloudName,
                      'instanceId':instanceId}
      nTry,response = self.requestJsonExchange(queryMessage)

      if nTry > 1:
         self.logger.log(logging.WARNING,getLogMessage("confirmation: getInstanceHostname(%d):%s" % \
                                                        (nTry,response['messageType'])))

      hostName = response['hostname']

      return(hostName)


   def reportAllInstances(self,
                          cloudName):
      report = ""

      queryMessage = {'messageType':'reportActiveCloudInstances',
                      'cloudDesignator':cloudName}
      nTry,response = self.requestJsonExchange(queryMessage)

      if nTry > 1:
         self.logger.log(logging.WARNING,getLogMessage("confirmation: reportActiveCloudInstances(%d):%s" % \
                                                        (nTry,response['messageType'])))

      report = response['report']

      return(report.strip())


