#!/usr/bin/env python
#
# @package      hubzero-submit-monitors
# @file         monitorTunnelR.py
# @author       Steven Clark <clarks@purdue.edu>
# @copyright    Copyright (c) 2004-2013 HUBzero Foundation, LLC.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2004-2013 HUBzero Foundation, LLC.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of HUBzero Foundation, LLC.
#
# ----------------------------------------------------------------------
#  monitorTunnelR.py
#
#  script which reports monitor status for all ssh tunnels
#
import sys

from hubzero.submit.RemoteTunnelMonitor import RemoteTunnelMonitor

TUNNELMONITORHOST = ""
TUNNELMONITORPORT = 5729

def monitorTunnelR():
   """Report ssh tunnel use"""
   if len(sys.argv) > 1:
      tunnelName = sys.argv[1]
   else:
      tunnelName = ""

   remoteTunnelMonitor = RemoteTunnelMonitor(TUNNELMONITORHOST,TUNNELMONITORPORT)

   report = remoteTunnelMonitor.reportTunnelUse(tunnelName)
   print("\n%-30s  %s" % ("Tunnel","useCount"))
   tunnels = report.split(':')
   for tunnel in tunnels:
      if tunnel != "":
         tunnelName,useCount = tunnel.split()
         print("%-30s  %s" % (tunnelName,useCount))


if __name__ == '__main__':
   monitorTunnelR()


