#!/usr/bin/env python3
#
# @package      hubzero-submit-monitors
# @file         monitorJobSQL.py
# @copyright    Copyright (c) 2004-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2004-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
# ----------------------------------------------------------------------
#  monitorJobSQL.py
#
#  script which gathers monitoring statistics from remote sites and
#  reports job status to distributor on demand
#
import sys
import os
import time
import logging

from hubzero.submit.ApplicationUtilities import ApplicationUtilities as ApplicationUtilities
from hubzero.submit.MonitorJobSQL        import MonitorJobSQL as MonitorJob

MONITORLOGLEVEL = "INFO"

MONITORDIRECTORY         = os.path.join(os.sep,"etc","submit")
MONITORCONFIGURATIONFILE = 'jobmonitor.conf'
DAEMONSDIRECTORY         = os.path.join(os.sep,"etc","submit")
DAEMONSCONFIGURATIONFILE = 'daemons.conf'
INFOSDIRECTORY           = os.path.join(os.sep,"etc","submit")
INFOSCONFIGURATIONFILE   = 'infos.conf'

MONITORROOT     = os.path.dirname(os.path.abspath(__file__))
MONITORSITEFILE = "monitorJobSiteSQL.py"
MONITORSITEPATH = os.path.join(MONITORROOT,MONITORSITEFILE)

MONITORLOGLOCATION = os.path.join(os.sep,'var','log','submit','monitors')
MONITORLOGFILENAME = "monitorJobSQL.log"

MONITORPIDFILE = os.path.join(os.sep,'var','run','submit','submit-jobsql.pid')

ACTIVITYUPDATEINTERVAL = 15.*60.

if __name__ == '__main__':
   monitorLogLevel          = os.getenv("MONITORLOGLEVEL",MONITORLOGLEVEL)
   monitorDirectory         = os.getenv("MONITORDIRECTORY",MONITORDIRECTORY)
   monitorConfigurationFile = os.getenv("MONITORCONFIGURATIONFILE",MONITORCONFIGURATIONFILE)
   monitorLogLocation       = os.getenv("MONITORLOGLOCATION",MONITORLOGLOCATION)
   monitorLogFilename       = os.getenv("MONITORLOGFILENAME",MONITORLOGFILENAME)
   monitorPidFile           = os.getenv("MONITORPIDFILE",MONITORPIDFILE)
   daemonsDirectory         = os.getenv("DAEMONSDIRECTORY",DAEMONSDIRECTORY)
   daemonsConfigurationFile = os.getenv("DAEMONSCONFIGURATIONFILE",DAEMONSCONFIGURATIONFILE)
   infosDirectory           = os.getenv("INFOSDIRECTORY",INFOSDIRECTORY)
   infosConfigurationFile   = os.getenv("INFOSCONFIGURATIONFILE",INFOSCONFIGURATIONFILE)
   activityUpdateInterval   = os.getenv("ACTIVITYUPDATEINTERVAL",ACTIVITYUPDATEINTERVAL)

   applicationUtilities = ApplicationUtilities(MONITORLOGLEVEL)
   applicationUtilities.openFileLogger(monitorLogLocation,monitorLogFilename,
                                       monitorLogLevel)
   applicationUtilities.daemonize()
   applicationUtilities.writePidFile(monitorPidFile)

   monitorJob = MonitorJob(monitorDirectory,monitorConfigurationFile,
                           daemonsDirectory,daemonsConfigurationFile,
                           infosDirectory,infosConfigurationFile,
                           MONITORSITEPATH,
                           activityUpdateInterval)
   monitorJob.monitor()


