#!/usr/bin/env python3
#
# @package      hubzero-submit-monitors
# @file         jobProcessor.py
# @copyright    Copyright (c) 2004-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2004-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
# ----------------------------------------------------------------------
#  jobProcessor.py
#
#  script which processes registered jobs
#
import sys
import os
import time
import logging

from hubzero.submit.ApplicationUtilities import ApplicationUtilities as ApplicationUtilities
from hubzero.submit.ProcessJobs          import ProcessJobs

PROCESSORLOGLEVEL         = "INFO"
PROCESSORSYSLOGLOCAL      = "LOCAL3"
PROCESSORSYSLOGIDENTIFIER = "SUBMITJOBPRO"

DAEMONSDIRECTORY         = os.path.join(os.sep,"etc","submit")
DAEMONSCONFIGURATIONFILE = 'daemons.conf'

PROCESSORPIDFILE = os.path.join(os.sep,'var','run','submit','submit-jobprocessor.pid')

if __name__ == '__main__':
   processorLogLevel         = os.getenv("PROCESSORLOGLEVEL",PROCESSORLOGLEVEL)
   processorSysLogLocal      = os.getenv("PROCESSORSYSLOGLOCAL",PROCESSORSYSLOGLOCAL)
   processorSysLogIdentifier = os.getenv("PROCESSORSYSLOGIDENTIFIER",PROCESSORSYSLOGIDENTIFIER)
   processorPidFile          = os.getenv("PROCESSORPIDFILE",PROCESSORPIDFILE)
   daemonsDirectory          = os.getenv("DAEMONSDIRECTORY",DAEMONSDIRECTORY)
   daemonsConfigurationFile  = os.getenv("DAEMONSCONFIGURATIONFILE",DAEMONSCONFIGURATIONFILE)

   applicationUtilities = ApplicationUtilities(PROCESSORLOGLEVEL,
                                               defaultSysLogLocal=PROCESSORSYSLOGLOCAL)
   applicationUtilities.openSysLogLogger(processorSysLogLocal,
                                         processorLogLevel,
                                         logIdentifier=processorSysLogIdentifier)
   applicationUtilities.daemonize()
   applicationUtilities.writePidFile(processorPidFile)

   processJobs = ProcessJobs(daemonsDirectory,
                             daemonsConfigurationFile)
   processJobs.process()


