#!/usr/bin/env python3
#
# @package      hubzero-submit-monitors
# @file         monitorJobQ.py
# @copyright    Copyright (c) 2004-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2004-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
# ----------------------------------------------------------------------
#  monitorJobQ.py
#
#  script which queries monitorJob.py for job status
#
import os
import sys
import logging

from hubzero.submit.ApplicationUtilities import ApplicationUtilities as ApplicationUtilities
from hubzero.submit.DaemonsInfo          import DaemonsInfo
from hubzero.submit.RemoteJobMonitor     import RemoteJobMonitor

SUBMITUTILITYLOGLEVEL = "ERROR"

DAEMONSDIRECTORY         = os.path.join(os.sep,"etc","submit")
DAEMONSCONFIGURATIONFILE = 'daemons.conf'

def monitorJobQ(listenURI):
   """job Query"""
   siteDesignator = sys.argv[1]
   remoteJobId    = sys.argv[2]

   remoteJobMonitor = RemoteJobMonitor(listenURI)

   currentInstance  = remoteJobMonitor.queryRemoteJobStatus(siteDesignator,remoteJobId)
   currentJobStatus = currentInstance['status']
   currentJobStage  = currentInstance['stage']
   currentJobSite   = currentInstance['site']
   print("%s   %s    %s    %s" % (remoteJobId,currentJobStatus,currentJobStage,currentJobSite))

   if "#STDOUT#" in currentInstance['tailFiles']:
      sys.stdout.write(currentInstance['tailFiles']["#STDOUT#"])
   if "#STDERR#" in currentInstance['tailFiles']:
      sys.stderr.write(currentInstance['tailFiles']["#STDERR#"])


if __name__ == '__main__':
   submitUtilityLogLevel    = os.getenv("SUBMITUTILITYLOGLEVEL",SUBMITUTILITYLOGLEVEL)
   daemonsDirectory         = os.getenv("DAEMONSDIRECTORY",DAEMONSDIRECTORY)
   daemonsConfigurationFile = os.getenv("DAEMONSCONFIGURATIONFILE",DAEMONSCONFIGURATIONFILE)

   applicationUtilities = ApplicationUtilities(SUBMITUTILITYLOGLEVEL)
   applicationUtilities.openStreamLogger(sys.stderr,
                                         submitUtilityLogLevel)

   configFilePath = os.path.join(daemonsDirectory,daemonsConfigurationFile)
   daemonsInfo    = DaemonsInfo(configFilePath)
   listenURI      = daemonsInfo.getDaemonListenURI('jobMonitor','tcp')

   monitorJobQ(listenURI)


