<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="cli-pegasus-monitord.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="cli-pegasus-plan.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div lang="en" class="refentry" title="pegasus-mpi-cluster">
<a name="cli-pegasus-mpi-cluster"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-mpi-cluster — a tool for running computational workflows expressed as DAGs (Directed Acyclic Graphs) on computational clusters using MPI.</p>
</div>
<div class="refsynopsisdiv" title="Synopsis">
<a name="pegasus-mpi-cluster_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-mpi-cluster</strong></span> [options] <span class="emphasis"><em>workflow.dag</em></span></p></div></blockquote></div>
</div>
<div class="refsect1" title="Description">
<a name="pegasus-mpi-cluster_description"></a><h2>Description</h2>
<p><span class="strong"><strong>pegasus-mpi-cluster</strong></span> is a tool used to run HTC (High Throughput Computing) scientific
workflows on systems designed for HPC (High Performance Computing).
Many HPC systems have custom architectures that are optimized for
tightly-coupled, parallel applications. These systems commonly have
exotic, low-latency networks that are designed for passing short
messages very quickly between compute nodes. Many of these networks are so
highly optimized that the compute nodes do not even support a TCP/IP
stack. This makes it impossible to run HTC applications using software
that was designed for commodity clusters, such as Condor.</p>
<p><span class="strong"><strong>pegasus-mpi-cluster</strong></span> was developed to enable loosely-coupled HTC applications such as
scientific workflows to take advantage of HPC systems. In order to get
around the network issues outlined above, <span class="strong"><strong>pegasus-mpi-cluster</strong></span> uses MPI (Message
Passing Interface), a commonly used API for writing SPMD (Single
Process, Multiple Data) parallel applications. Most HPC systems have an
MPI implementation that works on whatever exotic network architecture
the system uses.</p>
<p>An <span class="strong"><strong>pegasus-mpi-cluster</strong></span> job consists of a single master process (this process is rank
0 in MPI parlance) and several worker processes. The master process
manages the workflow and assigns workflow tasks to workers for execution.
The workers execute the tasks and return the results to the master. Any
output written to stdout or stderr by the tasks is captured (see
<a class="link" href="cli-pegasus-mpi-cluster.php#TASK_STDIO" title="Task STDIO"><span class="strong"><strong>TASK STDIO</strong></span></a>).</p>
<p><span class="strong"><strong>pegasus-mpi-cluster</strong></span> applications are expressed as DAGs (Directed Acyclic Graphs)
(see <a class="link" href="cli-pegasus-mpi-cluster.php#DAG_FILES" title="DAG Files"><span class="strong"><strong>DAG FILES</strong></span></a>). Each node in the graph represents a task,
and the edges represent dependencies between the tasks that constrain the
order in which the tasks are executed. Each task is a program and a set of
parameters that need to be run (i.e. a command and some optional
arguments). The dependencies typically represent data flow dependencies in
the application, where the output files produced by one task are needed
as inputs for another.</p>
<p>If an error occurs while executing a DAG that causes the workflow to
stop, it can be restarted using a rescue file, which records the
progress of the workflow (see <a class="link" href="cli-pegasus-mpi-cluster.php#RESCUE_FILES" title="Rescue Files"><span class="strong"><strong>RESCUE FILES</strong></span></a>). This
enables <span class="strong"><strong>pegasus-mpi-cluster</strong></span> to pick up running the workflow where it stopped.</p>
<p><span class="strong"><strong>pegasus-mpi-cluster</strong></span> was designed to work either as a standalone tool or
as a complement to the Pegasus Workflow Managment System (WMS). For more
information about using PMC with Pegasus see the section on <a class="link" href="cli-pegasus-mpi-cluster.php#PMC_AND_PEGASUS" title="PMC and Pegasus"><span class="strong"><strong>PMC AND PEGASUS</strong></span></a>.</p>
<p><span class="strong"><strong>pegasus-mpi-cluster</strong></span> allows applications expressed as a DAG to be executed in
parallel on a large number of compute nodes. It is designed to be simple,
lightweight and robust.</p>
</div>
<div class="refsect1" title="Options">
<a name="pegasus-mpi-cluster_options"></a><h2>Options</h2>
<div class="variablelist"><dl>
<dt>
<span class="term">
<span class="strong"><strong>-h</strong></span>
, </span><span class="term">
<span class="strong"><strong>--help</strong></span>
</span>
</dt>
<dd>
    Print help message
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-V</strong></span>
, </span><span class="term">
<span class="strong"><strong>--version</strong></span>
</span>
</dt>
<dd>
    Print version information
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-v</strong></span>
, </span><span class="term">
<span class="strong"><strong>--verbose</strong></span>
</span>
</dt>
<dd>
    Increase logging verbosity. Adding multiple <span class="strong"><strong>-v</strong></span> increases the
    level more. The default log level is <span class="emphasis"><em>INFO</em></span>. (see <a class="link" href="cli-pegasus-mpi-cluster.php#LOGGING" title="Logging"><span class="strong"><strong>LOGGING</strong></span></a>)
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-q</strong></span>
, </span><span class="term">
<span class="strong"><strong>--quiet</strong></span>
</span>
</dt>
<dd>
    Decrease logging verbosity. Adding multiple <span class="strong"><strong>-q</strong></span> decreases the
    level more. The default log level is <span class="emphasis"><em>INFO</em></span>. (see <a class="link" href="cli-pegasus-mpi-cluster.php#LOGGING" title="Logging"><span class="strong"><strong>LOGGING</strong></span></a>)
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-s</strong></span>
, </span><span class="term">
<span class="strong"><strong>--skip-rescue</strong></span>
</span>
</dt>
<dd>
    Ignore the rescue file for <span class="emphasis"><em>workflow.dag</em></span> if it exists. Note that
    <span class="strong"><strong>pegasus-mpi-cluster</strong></span> will still create a new rescue file for the
    current run. The default behavior is to use the rescue file if one
    is found. (see <a class="link" href="cli-pegasus-mpi-cluster.php#RESCUE_FILES" title="Rescue Files"><span class="strong"><strong>RESCUE FILES</strong></span></a>)
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-o</strong></span> <span class="emphasis"><em>path</em></span>
, </span><span class="term">
<span class="strong"><strong>--stdout</strong></span> <span class="emphasis"><em>path</em></span>
</span>
</dt>
<dd>
    Path to file for task stdout. (see <a class="link" href="cli-pegasus-mpi-cluster.php#TASK_STDIO" title="Task STDIO"><span class="strong"><strong>TASK STDIO</strong></span></a> and
    <span class="strong"><strong>--per-task-stdio</strong></span>)
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-e</strong></span> <span class="emphasis"><em>path</em></span>
, </span><span class="term">
<span class="strong"><strong>--stderr</strong></span> <span class="emphasis"><em>path</em></span>
</span>
</dt>
<dd>
    Path to file for task stderr. (see <a class="link" href="cli-pegasus-mpi-cluster.php#TASK_STDIO" title="Task STDIO"><span class="strong"><strong>TASK STDIO</strong></span></a> and
    <span class="strong"><strong>--per-task-stdio</strong></span>)
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-m</strong></span> <span class="emphasis"><em>M</em></span>
, </span><span class="term">
<span class="strong"><strong>--max-failures</strong></span> <span class="emphasis"><em>M</em></span>
</span>
</dt>
<dd>
    Stop submitting new tasks after <span class="emphasis"><em>M</em></span> tasks have failed. Once <span class="emphasis"><em>M</em></span>
    has been reached, <span class="strong"><strong>pegasus-mpi-cluster</strong></span> will finish running any tasks that have
    been started, but will not start any more tasks. This option is
    used to prevent <span class="strong"><strong>pegasus-mpi-cluster</strong></span> from continuing to run a workflow that
    is suffering from a systematic error, such as a missing binary or
    an invalid path. The default for <span class="emphasis"><em>M</em></span> is 0, which means unlimited
    failures are allowed.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-t</strong></span> <span class="emphasis"><em>T</em></span>
, </span><span class="term">
<span class="strong"><strong>--tries</strong></span> <span class="emphasis"><em>T</em></span>
</span>
</dt>
<dd>
    Attempt to run each task <span class="emphasis"><em>T</em></span> times before marking the task as failed.
    Note that the <span class="emphasis"><em>T</em></span> tries do not count as failures for the purposes of the
    <span class="strong"><strong>-m</strong></span> option. A task is only considered failed if it is tried <span class="emphasis"><em>T</em></span> times
    and all <span class="emphasis"><em>T</em></span> attempts result in a non-zero exitcode. The value of <span class="emphasis"><em>T</em></span> must
    be at least 1. The default is 1.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-n</strong></span>
, </span><span class="term">
<span class="strong"><strong>--nolock</strong></span>
</span>
</dt>
<dd>
    Do not lock DAGFILE. By default, <span class="strong"><strong>pegasus-mpi-cluster</strong></span> will attempt to acquire
    an exclusive lock on DAGFILE to prevent multiple MPI jobs from running the same
    DAG at the same time. If this option is specified, then the lock will not be
    acquired.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-r</strong></span>
, </span><span class="term">
<span class="strong"><strong>--rescue</strong></span> <span class="emphasis"><em>path</em></span>
</span>
</dt>
<dd>
    Path to rescue log. If the file exists, and <span class="strong"><strong>-s</strong></span> is not specified, then
    the log will be used to recover the state of the workflow. The file is truncated
    after it is read and a new rescue log is created in its place. The default is to
    append <span class="emphasis"><em>.rescue</em></span> to the DAG file name. (see <a class="link" href="cli-pegasus-mpi-cluster.php#RESCUE_FILES" title="Rescue Files"><span class="strong"><strong>RESCUE FILES</strong></span></a>)
</dd>
<dt><span class="term">
<span class="strong"><strong>--host-script</strong></span> <span class="emphasis"><em>path</em></span>
</span></dt>
<dd>
    Path to a script or executable to launch on each unique host that
    <span class="strong"><strong>pegasus-mpi-cluster</strong></span> is running on. This path can also be set using the
    PMC_HOST_SCRIPT environment variable. (see <a class="link" href="cli-pegasus-mpi-cluster.php#HOST_SCRIPTS" title="Host Scripts"><span class="strong"><strong>HOST SCRIPTS</strong></span></a>)
</dd>
<dt><span class="term">
<span class="strong"><strong>--host-memory</strong></span> <span class="emphasis"><em>size</em></span>
</span></dt>
<dd>
    Amount of memory available on each host in MB. The default is to
    determine the amount of physical RAM automatically. This value can also
    be set using the PMC_HOST_MEMORY environment variable. (see
    <a class="link" href="cli-pegasus-mpi-cluster.php#RESOURCE_SCHED" title="Resource-Based Scheduling"><span class="strong"><strong>RESOURCE-BASED SCHEDULING</strong></span></a>)
</dd>
<dt><span class="term">
<span class="strong"><strong>--host-cpus</strong></span> <span class="emphasis"><em>cpus</em></span>
</span></dt>
<dd>
    Number of CPUs available on each host. The default is to determine the
    number of CPU cores automatically. This value can also be set using the
    PMC_HOST_CPUS environment variable. (see <a class="link" href="cli-pegasus-mpi-cluster.php#RESOURCE_SCHED" title="Resource-Based Scheduling"><span class="strong"><strong>RESOURCE-BASED SCHEDULING</strong></span></a>)
</dd>
<dt><span class="term">
<span class="strong"><strong>--strict-limits</strong></span>
</span></dt>
<dd>
    This enables strict memory usage limits for tasks. When this option is
    specified, and a task tries to allocate more memory than was requested
    in the DAG, the memory allocation operation will fail.
</dd>
<dt><span class="term">
<span class="strong"><strong>--max-wall-time</strong></span> <span class="emphasis"><em>minutes</em></span>
</span></dt>
<dd>
    This is the maximum number of minutes that <span class="strong"><strong>pegasus-mpi-cluster</strong></span> will
    allow the workflow to run. When this time expires <span class="strong"><strong>pegasus-mpi-cluster</strong></span>
    will abort the workflow and merge all of the stdout/stderr files of the
    workers. The value is in minutes, and the default is unlimited wall
    time. This option was added so that the output of a workflow will be
    recorded even if the workflow exceeds the max wall time of its batch job.
    This value can also be set using the PMC_MAX_WALL_TIME environment
    variable.
</dd>
<dt><span class="term">
<span class="strong"><strong>--per-task-stdio</strong></span>
</span></dt>
<dd>
    This causes PMC to generate a .out.XXX and a .err.XXX file for each task
    instead of writing task stdout/stderr to <span class="strong"><strong>--stdout</strong></span> and <span class="strong"><strong>--stderr</strong></span>. The
    name of the files are "TASKNAME.out.XXX" and "TASKNAME.err.XXX", where
    "TASKNAME" is the name of the task from the DAG and "XXX" is a sequence
    number that is incremented each time the task is tried. This option
    overrides the values for <span class="strong"><strong>--stdout</strong></span> and <span class="strong"><strong>--stderr</strong></span>. This argument is used
    by Pegasus when workflows are planned in PMC-only mode to facilitate
    debugging and monitoring.
</dd>
<dt><span class="term">
<span class="strong"><strong>--jobstate-log</strong></span>
</span></dt>
<dd>
    This option causes PMC to generate a jobstate.log file for the workflow.
    The file is named "jobstate.log" and is placed in the same directory where
    the DAG file is located. If the file already exists, then PMC appends new
    lines to the existing file. This option is used by Pegasus when workflows
    are planned in PMC-only mode to facilitate monitoring.
</dd>
<dt><span class="term">
<span class="strong"><strong>--monitord-hack</strong></span>
</span></dt>
<dd>
    This option causes PMC to generate a .dagman.out file for the workflow.
    This file mimics the contents of the .dagman.out file generated by Condor
    DAGMan. The point of this option is to trick monitord into thinking that
    it is dealing with DAGMan so that it will generate the appropriate events
    to populate the STAMPEDE database for monitoring purposes. The file is
    named "DAG.dagman.out" where "DAG" is the path to the PMC DAG file.
</dd>
<dt><span class="term">
<span class="strong"><strong>--no-resource-log</strong></span>
</span></dt>
<dd>
    Do not generate a <span class="emphasis"><em>workflow.dag.resource</em></span> file for the workflow.
</dd>
<dt><span class="term">
<span class="strong"><strong>--no-sleep-on-recv</strong></span>
</span></dt>
<dd>
    Do not use polling with sleep() to implement message receive. (see
    <a class="link" href="cli-pegasus-mpi-cluster.php#CPU_USAGE_ISSUE" title="CPU Usage"><span class="strong"><strong>Known Issues: CPU Usage</strong></span></a>)
</dd>
<dt><span class="term">
<span class="strong"><strong>--maxfds</strong></span>
</span></dt>
<dd>
    Set the maximum number of file descriptors that can be left open by
    the master for I/O forwarding. By default this value is set automatically
    based on the value of getrlimit(RLIMIT_NOFILE). The value must be
    at least 1, and cannot be more than RLIMIT_NOFILE.
</dd>
<dt><span class="term">
<span class="strong"><strong>--keep-affinity</strong></span>
</span></dt>
<dd>
    By default PMC attempts to reset the CPU and memory affinity. This
    is to ensure that all available CPUs and memory can be used by PMC tasks
    on systems that are not configured properly. This flag tells PMC to keep
    the affinity settings inherited from its parent. Note that the memory
    policy can only be cleared if PMC was compiled with libnuma. CPU
    affinity is cleared using <span class="strong"><strong>sched_setaffinity()</strong></span>, and memory policy is
    cleared with <span class="strong"><strong>set_mempolicy()</strong></span>.
</dd>
</dl></div>
</div>
<div class="refsect1" title="DAG Files">
<a name="DAG_FILES"></a><h2>DAG Files</h2>
<p><span class="strong"><strong>pegasus-mpi-cluster</strong></span> workflows are expressed using a simple text-based
format similar to that used by Condor DAGMan. There are only two record
types allowed in a DAG file: <span class="strong"><strong>TASK</strong></span> and <span class="strong"><strong>EDGE</strong></span>. Any blank lines in the DAG
(lines with all whitespace characters) are ignored, as are any lines
beginning with # (note that # can only appear at the beginning of a line,
not in the middle).</p>
<p>The format of a <span class="strong"><strong>TASK</strong></span> record is:</p>
<pre class="screen">"TASK" id [options...] executable [arguments...]</pre>
<p>Where <span class="emphasis"><em>id</em></span> is the ID of the task, <span class="emphasis"><em>options</em></span> is a list of task options, <span class="emphasis"><em>executable</em></span> is
the path to the executable or script to run, and <span class="emphasis"><em>arguments…</em></span> is a space-separated
list of arguments to pass to the task. An example is:</p>
<pre class="screen">TASK t01 -m 10 -c 2 /bin/program -a -b</pre>
<p>This example specifies a task <span class="emphasis"><em>t01</em></span> that requires 10 MB memory and 2 CPUs to run
<span class="emphasis"><em>/bin/program</em></span> with the arguments <span class="emphasis"><em>-a</em></span> and <span class="emphasis"><em>-b</em></span>. The available task options are:</p>
<div class="variablelist"><dl>
<dt>
<span class="term">
<span class="strong"><strong>-m</strong></span> <span class="emphasis"><em>M</em></span>
, </span><span class="term">
<span class="strong"><strong>--request-memory</strong></span> <span class="emphasis"><em>M</em></span>
</span>
</dt>
<dd>
        The amount of memory required by the task in MB. The default is 0,
        which means memory is not considered for this task. This option can
        be set for a job in the DAX by specifying the pegasus::pmc_request_memory
        profile. (see <a class="link" href="cli-pegasus-mpi-cluster.php#RESOURCE_SCHED" title="Resource-Based Scheduling"><span class="strong"><strong>RESOURCE-BASED SCHEDULING</strong></span></a>)
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-c</strong></span> <span class="emphasis"><em>N</em></span>
, </span><span class="term">
<span class="strong"><strong>--request-cpus</strong></span> <span class="emphasis"><em>N</em></span>
</span>
</dt>
<dd>
        The number of CPUs required by the task. The default is 1, which implies that
        the number of slots on a host should be less than or equal to the number of
        physical CPUs in order for all the slots to be used. This option can be set
        for a job in the DAX by specifying the pegasus::pmc_request_cpus profile.
        (see <a class="link" href="cli-pegasus-mpi-cluster.php#RESOURCE_SCHED" title="Resource-Based Scheduling"><span class="strong"><strong>RESOURCE-BASED SCHEDULING</strong></span></a>)
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-t</strong></span> <span class="emphasis"><em>T</em></span>
, </span><span class="term">
<span class="strong"><strong>--tries</strong></span> <span class="emphasis"><em>T</em></span>
</span>
</dt>
<dd>
        The number of times to try to execute the task before failing permanently.
        This is the task-level equivalent of the <span class="strong"><strong>--tries</strong></span> command-line option.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-p</strong></span> <span class="emphasis"><em>P</em></span>
, </span><span class="term">
<span class="strong"><strong>--priority</strong></span> <span class="emphasis"><em>P</em></span>
</span>
</dt>
<dd>
        The priority of the task. P should be an integer. Larger values have
        higher priority. The default is 0. Priorities are simply hints and
        are not strict—if a task cannot be matched to an available slot
        (e.g. due to resource availability), but a lower-priority task can,
        then the task will be deferred and the lower priority task will be
        executed. This option can be set for a job in the DAX by specifying
        the pegasus::pmc_priority profile.
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-f</strong></span> <span class="emphasis"><em>VAR=FILE</em></span>
, </span><span class="term">
<span class="strong"><strong>--pipe-forward</strong></span> <span class="emphasis"><em>VAR=FILE</em></span>
</span>
</dt>
<dd>
        Forward I/O to file <span class="emphasis"><em>FILE</em></span> using pipes to communicate with the task.
        The environment variable <span class="emphasis"><em>VAR</em></span> will be set to the value of a file
        descriptor for a pipe to which the task can write
        to get data into <span class="emphasis"><em>FILE</em></span>. For example, if a task specifies:
        -f FOO=/tmp/foo then the environment variable FOO for the task will
        be set to a number (e.g. 3) that represents the file /tmp/foo.
        In order to specify this argument in a Pegasus DAX you need to set the
        pegasus::pmc_arguments profile (note that the value of pmc_arguments
        must contain the "-f" part of the argument, so a valid value would
        be: &lt;profile namespace="pegasus" key="pmc_arguments"&gt;-f A=/tmp/a
        &lt;/profile&gt;). (see <a class="link" href="cli-pegasus-mpi-cluster.php#IO_FORWARDING" title="I/O Forwarding"><span class="strong"><strong>I/O FORWARDING</strong></span></a>)
</dd>
<dt>
<span class="term">
<span class="strong"><strong>-F</strong></span> <span class="emphasis"><em>SRC=DEST</em></span>
, </span><span class="term">
<span class="strong"><strong>--file-forward</strong></span> <span class="emphasis"><em>SRC=DEST</em></span>
</span>
</dt>
<dd>
        Forward I/O to the file <span class="emphasis"><em>DEST</em></span> from the file <span class="emphasis"><em>SRC</em></span>. When the task
        finishes, the worker will read the data from <span class="emphasis"><em>SRC</em></span> and send it to
        the master where it will be written to the file <span class="emphasis"><em>DEST</em></span>. After <span class="emphasis"><em>SRC</em></span>
        is read it is deleted. In order to specify this argument in a
        Pegasus DAX you need to set the pegasus::pmc_arguments profile.
        (see <a class="link" href="cli-pegasus-mpi-cluster.php#IO_FORWARDING" title="I/O Forwarding"><span class="strong"><strong>I/O FORWARDING</strong></span></a>)
</dd>
</dl></div>
<p>The format of an <span class="strong"><strong>EDGE</strong></span> record is:</p>
<pre class="screen">"EDGE" parent child</pre>
<p>Where <span class="emphasis"><em>parent</em></span> is the ID of the parent task, and <span class="emphasis"><em>child</em></span> is the ID of the
child task. An example <span class="strong"><strong>EDGE</strong></span> record is:</p>
<pre class="screen">EDGE t01 t02</pre>
<p>A simple diamond-shaped workflow would look like this:</p>
<pre class="screen"># diamond.dag
TASK A /bin/echo "I am A"
TASK B /bin/echo "I am B"
TASK C /bin/echo "I am C"
TASK D /bin/echo "I am D"

EDGE A B
EDGE A C
EDGE B D
EDGE C D</pre>
</div>
<div class="refsect1" title="Rescue Files">
<a name="RESCUE_FILES"></a><h2>Rescue Files</h2>
<p>Many different types of errors can occur when running a DAG. One or
more of the tasks may fail, the MPI job may run out of wall time,
<span class="strong"><strong>pegasus-mpi-cluster</strong></span> may segfault (we hope not), the system may crash,
etc. In order to ensure that the DAG does not need to be restarted from
the beginning after an error, <span class="strong"><strong>pegasus-mpi-cluster</strong></span> generates a rescue
file for each workflow.</p>
<p>The rescue file is a simple text file that lists all of the tasks in
the workflow that have finished successfully. This file is updated each
time a task finishes, and is flushed periodically so that if the work-
flow fails and the user restarts it, <span class="strong"><strong>pegasus-mpi-cluster</strong></span> can determine
which tasks still need to be executed. As such, the rescue file is a
sort-of transaction log for the workflow.</p>
<p>The rescue file contains zero or more DONE records. The format of these
records is:</p>
<pre class="screen">"DONE" *taskid*</pre>
<p>Where <span class="emphasis"><em>taskid</em></span> is the ID of the task that finished successfully.</p>
<p>By default, rescue files are named <span class="emphasis"><em>DAGNAME.rescue</em></span> where <span class="emphasis"><em>DAGNAME</em></span> is the
path to the input DAG file. The file name can be changed by specifying the
<span class="strong"><strong>-r</strong></span> argument.</p>
</div>
<div class="refsect1" title="PMC and Pegasus">
<a name="PMC_AND_PEGASUS"></a><h2>PMC and Pegasus</h2>
<div class="refsect2" title="Using PMC for Pegasus Task Clustering">
<a name="pegasus-mpi-cluster_using_pmc_for_pegasus_task_clustering"></a><h3>Using PMC for Pegasus Task Clustering</h3>
<p>PMC can be used as the wrapper for executing clustered jobs in Pegasus. In
this mode Pegasus groups several tasks together and submits them as a single
clustered job to a remote system. PMC then executes the individual tasks in
the cluster and returns the results.</p>
<p>PMC can be specified as the task manager for clustered jobs in Pegasus in
three ways:</p>
<div class="orderedlist"><ol class="orderedlist" type="1">
<li class="listitem">
<p class="simpara">
Globally in the properties file
</p>
<p class="simpara">The user can set a property in the properties file that results in all
the clustered jobs of the workflow being executed by PMC. In the Pegasus
properties file specify:</p>
<pre class="screen">#PEGASUS PROPERTIES FILE
pegasus.clusterer.job.aggregator=mpiexec</pre>
<p class="simpara">In the above example, all the clustered jobs on all remote sites will
be launched via PMC as long as the property value is not overridden
in the site catalog.</p>
</li>
<li class="listitem">
<p class="simpara">
By setting the profile key "job.aggregator" in the site catalog:
</p>
<pre class="screen">&lt;site handle="siteX" arch="x86" os="LINUX"&gt;
    ...
    &lt;profile namespace="pegasus" key="job.aggregator"&gt;mpiexec&lt;/profile&gt;
&lt;/site&gt;</pre>
<p class="simpara">In the above example, all the clustered jobs on a siteX are going to
be executed via PMC as long as the value is not overridden in the
transformation catalog.</p>
</li>
<li class="listitem">
<p class="simpara">
By setting the profile key "job.aggregator" in the transformation catalog:
</p>
<pre class="screen">tr B {
    site siteX {
        pfn "/path/to/mytask"
        arch "x86"
        os "linux"
        type "INSTALLED"
        profile pegasus "clusters.size" "3"
        profile pegasus "job.aggregator" "mpiexec"
    }
}</pre>
<p class="simpara">In the above example, all the clustered jobs for transformation B on
siteX will be executed via PMC.</p>
</li>
</ol></div>
<p>It is usually necessary to have a pegasus::mpiexec entry in your
transformation catalog that specifies a) the path to PMC on the remote site
and b) the relevant globus profiles such as xcount, host_xcount and
maxwalltime to control size of the MPI job. That entry would look like
this:</p>
<pre class="screen">tr pegasus::mpiexec {
    site siteX {
        pfn "/path/to/pegasus-mpi-cluster"
        arch "x86"
        os "linux"
        type "INSTALLED"
        profile globus "maxwalltime" "240"
        profile globus "host_xcount" "1"
        profile globus "xcount" "32"
    }
}</pre>
<p>If this transformation catalog entry is not specified, Pegasus will
attempt create a default path on the basis of the environment profile
PEGASUS_HOME specified in the site catalog for the remote site.</p>
<p>PMC can be used with both horizontal and label-based clustering in
Pegasus, but we recommend using label-based clustering so that entire
sub-graphs of a Pegasus DAX can be clustered into a single PMC job,
instead of only a single level of the workflow.</p>
</div>
<div class="refsect2" title="Pegasus Profiles for PMC">
<a name="pegasus-mpi-cluster_pegasus_profiles_for_pmc"></a><h3>Pegasus Profiles for PMC</h3>
<p>There are several Pegasus profiles that map to PMC task options:</p>
<div class="variablelist"><dl>
<dt><span class="term">
<span class="strong"><strong>pmc_request_memory</strong></span>
</span></dt>
<dd>
    This profile is used to set the --request-memory task option and is
    usually specified in the DAX or transformation catalog.
</dd>
<dt><span class="term">
<span class="strong"><strong>pmc_request_cpus</strong></span>
</span></dt>
<dd>
    This key is used to set the --request-cpus task option and is usually
    specified in the DAX or transformation catalog.
</dd>
<dt><span class="term">
<span class="strong"><strong>pmc_priority</strong></span>
</span></dt>
<dd>
    This key is used to set the --priority task option and is usually
    specified in the DAX.
</dd>
</dl></div>
<p>These profiles are used by Pegasus when generating PMC’s input DAG when
PMC is used as the task manager for clustered jobs in Pegasus.</p>
<p>The profiles can be specified in the DAX like this:</p>
<pre class="screen">&lt;job id="ID0000001" name="mytask"&gt;
    &lt;arguments&gt;-a 1 -b 2 -c 3&lt;/arguments&gt;
    ...
    &lt;profile namespace="pegasus" key="pmc_request_memory"&gt;1024&lt;/profile&gt;
    &lt;profile namespace="pegasus" key="pmc_request_cpus"&gt;4&lt;/profile&gt;
    &lt;profile namespace="pegasus" key="pmc_priority"&gt;10&lt;/profile&gt;
&lt;/job&gt;</pre>
<p>This example specifies a PMC task that requires 1GB of memory and 4 cores,
and has a priority of 10. It produces a task in the PMC DAG that looks like
this:</p>
<pre class="screen">TASK mytask_ID00000001 -m 1024 -c 4 -p 10 /path/to/mytask -a 1 -b 2 -c 3</pre>
</div>
<div class="refsect2" title="Using PMC for the Entire Pegasus DAX">
<a name="pegasus-mpi-cluster_using_pmc_for_the_entire_pegasus_dax"></a><h3>Using PMC for the Entire Pegasus DAX</h3>
<p>Pegasus can also be configured to run the entire workflow as a single PMC
job. In this mode Pegasus will generate a single PMC DAG for the entire
workflow as well as a PBS script that can be used to submit the workflow.</p>
<p>In contrast to using PMC as a task clustering tool, in this mode there
are no jobs in the workflow executed without PMC. The entire workflow,
including auxilliary jobs such as directory creation and file transfers,
is managed by PMC. If Pegasus is configured in this mode, then DAGMan
and Condor are not required.</p>
<p>To run in PMC-only mode, set the property "pegasus.code.generator" to "PMC"
in the Pegasus properties file:</p>
<pre class="screen">pegasus.code.generator=PMC</pre>
<p>In order to submit the resulting PBS job you may need to make changes to
the .pbs file generated by Pegasus to get it to work with your cluster.
This mode is experimental and has not been used extensively.</p>
</div>
</div>
<div class="refsect1" title="Logging">
<a name="LOGGING"></a><h2>Logging</h2>
<p>By default, all logging messages are printed to stderr. If you turn up
the logging using <span class="strong"><strong>-v</strong></span> then you may end up with a lot of stderr being
forwarded from the workers to the master.</p>
<p>The log levels in order of severity are: FATAL, ERROR, WARN, INFO, DEBUG,
and TRACE.</p>
<p>The default logging level is INFO. The logging levels can be
increased with <span class="strong"><strong>-v</strong></span> and decreased with <span class="strong"><strong>-q</strong></span>.</p>
</div>
<div class="refsect1" title="Task STDIO">
<a name="TASK_STDIO"></a><h2>Task STDIO</h2>
<p>By default the stdout and stderr of tasks will be redirected to the master’s
stdout and stderr. You can change the path of these files with the <span class="strong"><strong>-o</strong></span> and
<span class="strong"><strong>-e</strong></span> arguments. You can also enable per-task stdio files using the
<span class="strong"><strong>--per-task-stdio</strong></span> argument. Note that if per-task stdio files are not used
then the stdio of all workers will be merged into one out and one err file
by the master at the end, so I/O from different workers will not be
interleaved, but I/O from each worker will appear in the order that it was
generated. Also note that, if the job fails for any reason, the outputs will
not be merged, but instead there will be one file for each worker named
DAGFILE.out.X and DAGFILE.err.X, where DAGFILE is the path to the input DAG,
and <span class="emphasis"><em>X</em></span> is the worker’s rank.</p>
</div>
<div class="refsect1" title="Host Scripts">
<a name="HOST_SCRIPTS"></a><h2>Host Scripts</h2>
<p>A host script is a shell script or executable that <span class="strong"><strong>pegasus-mpi-cluster</strong></span>
launches on each unique host on which it is running. They can be used to
start auxilliary services, such as memcached, that the tasks in a workflow
require.</p>
<p>Host scripts are specified using either the <span class="strong"><strong>--host-script</strong></span> argument or
the <span class="strong"><strong>PMC_HOST_SCRIPT</strong></span> environment variable.</p>
<p>The host script is started when <span class="strong"><strong>pegasus-mpi-cluster</strong></span> starts and must exit
with an exitcode of 0 before any tasks can be executed. If it the host script
returns a non-zero exitcode, then the workflow is aborted. The host script
is given 60 seconds to do any setup that is required. If it doesn’t exit
in 60 seconds then a SIGALRM signal is delivered to the process, which, if not
handled, will cause the process to terminate.</p>
<p>When the workflow finishes, <span class="strong"><strong>pegasus-mpi-cluster</strong></span> will deliver a SIGTERM
signal to the host script’s process group. Any child processes left running
by the host script will receive this signal unless they created their own
process group. If there were any processes left to receive this signal, then
they will be given a few seconds to exit, then they will be sent SIGKILL.
This is the mechanism by which processes started by the host script can be
informed of the termination of the workflow.</p>
</div>
<div class="refsect1" title="Resource-Based Scheduling">
<a name="RESOURCE_SCHED"></a><h2>Resource-Based Scheduling</h2>
<p>High-performance computing resources often have a low ratio of memory to CPUs.
At the same time, workflow tasks often have high memory requirements. Often,
the memory requirements of a workflow task exceed the amount of memory
available to each CPU on a given host. As a result, it may be necessary to
disable some CPUs in order to free up enough memory to run the tasks. Similarly,
many codes have support for multicore hosts. In that case it is necessary for
efficiency to ensure that the number of cores required by the tasks running on
a host do not exceed the number of cores available on that host.</p>
<p>In order to make this process more efficient, <span class="strong"><strong>pegasus-mpi-cluster</strong></span> supports
resource-based scheduling. In resource-based scheduling the tasks in the
workflow can specify how much memory and how many CPUs they require, and
<span class="strong"><strong>pegasus-mpi-cluster</strong></span> will schedule them so that the tasks running on a given
host do not exceed the amount of physical memory and CPUs available. This
enables <span class="strong"><strong>pegasus-mpi-cluster</strong></span> to take advantage of all the CPUs available
when the tasks' memory requirement is low, but also disable some CPUs when
the tasks' memory requirement is higher. It also enables workflows with a
mixture of single core and multi-core tasks to be executed on a heterogenous
pool.</p>
<p>If there are no hosts available that have enough memory and CPUs to execute
one of the tasks in a workflow, then the workflow is aborted.</p>
<div class="refsect2" title="Memory">
<a name="pegasus-mpi-cluster_memory"></a><h3>Memory</h3>
<p>Users can specify both the amount of memory required per task, and the amount
of memory available per host. If the amount of memory required by any task
exceeds the available memory of all the hosts, then the workflow will be
aborted. By default, the host memory is determined automatically, however the
user can specify <span class="strong"><strong>--host-memory</strong></span> to "lie" to <span class="strong"><strong>pegasus-mpi-cluster</strong></span>. The amount
of memory required for each task is specified in the DAG using the
<span class="strong"><strong>-m</strong></span>/<span class="strong"><strong>--request-memory</strong></span> argument (see <a class="link" href="cli-pegasus-mpi-cluster.php#DAG_FILES" title="DAG Files"><span class="strong"><strong>DAG Files</strong></span></a>).</p>
</div>
<div class="refsect2" title="CPUs">
<a name="pegasus-mpi-cluster_cpus"></a><h3>CPUs</h3>
<p>Users can specify the number of CPUs required per task, and the total number of
CPUs available on each host. If the number of CPUs required by a task exceeds
the available CPUs on all hosts, then the workflow will be aborted. By default,
the number of CPUs on a host is determined automatically, but the user can
specify <span class="strong"><strong>--host-cpus</strong></span> to over- or under-subscribe the host. The number of
CPUs required for each task is specified in the DAG using the
<span class="strong"><strong>-c</strong></span>/<span class="strong"><strong>--request-cpus</strong></span> argument (see <a class="link" href="cli-pegasus-mpi-cluster.php#DAG_FILES" title="DAG Files"><span class="strong"><strong>DAG Files</strong></span></a>).</p>
</div>
</div>
<div class="refsect1" title="I/O Forwarding">
<a name="IO_FORWARDING"></a><h2>I/O Forwarding</h2>
<p>In workflows that have lots of small tasks it is common for the I/O written
by those tasks to be very small. For example, a workflow may have 10,000 tasks
that each write a few KB of data. Typically each task writes to its own file,
resulting in 10,000 files. This I/O pattern is very inefficient on many
parallel file systems because it requires the file system to handle a large
number of metadata operations, which are a bottleneck in many parallel file
systems.</p>
<p>One way to handle this problem is to have all 10,000 tasks write to a single
file. The problem with this approach is that it requires those tasks to
synchronize their access to the file using POSIX locks or some other mutual
exclusion mechanism. Otherwise, the writes from different tasks may be
interleaved in arbitrary order, resulting in unusable data.</p>
<p>In order to address this use case PMC implements a feature that we call "I/O
Forwarding". I/O forwarding enables each task in a PMC job to write data to
an arbitrary number of shared files in a safe way. It does this by having
PMC worker processes collect data written by the task and send it over
over the high-speed network using MPI messaging to the PMC master
process, where it is written to the output file. By having one process
(the PMC master process) write to the file all of the I/O from many parallel
tasks can be synchronized and written out to the files safely.</p>
<p>There are two different ways to use I/O forwarding in PMC: pipes and files.
Pipes are more efficient, but files are easier to use.</p>
<div class="refsect2" title="I/O forwarding using pipes">
<a name="pegasus-mpi-cluster_i_o_forwarding_using_pipes"></a><h3>I/O forwarding using pipes</h3>
<p>I/O forwarding with pipes works by having PMC worker processes collect data
from each task using UNIX pipes. This approach is more efficient than the
file-based approach, but it requires the code of the task to be changed so
that the task writes to the pipe instead of a regular file.</p>
<p>In order to use I/O forwarding a PMC task just needs to specify the
<span class="strong"><strong>-f/--pipe-forward</strong></span> argument to specify the name of the file to forward
data to, and the name of an environment variable through which the PMC
worker process can inform it of the file descriptor for the pipe.</p>
<p>For example, if there is a task "mytask" that needs to forward data to two
files: "myfile.a" and "myfile.b", it would look like this:</p>
<pre class="screen">TASK mytask -f A=/tmp/myfile.a -f B=/tmp/myfile.b /bin/mytask</pre>
<p>When the /bin/mytask process starts it will have two variables in its
environment: "A=3" and "B=4", for example. The value of these variables
is the file descriptor number of the corresponding files. In this case,
if the task wants to write to "/tmp/myfile.a", it gets the value of
environment variable "A", and calls write() on that descriptor number.
In C the code for that looks like this:</p>
<pre class="screen">char *A = getenv("A");
int fd = atoi(A);
char *message = "Hello, World\n";
write(fd, message, strlen(message));</pre>
<p>In some programming languages it is not possible to write to a file
descriptor directly. Fortran, for example, refers to files by unit
number instead of using file descriptors. In these languages you
can either link C I/O functions into your binary and call them from
routines written in the other language, or you can open a special
file in the Linux /proc file system to get another handle to the
pipe you want to access. For the latter, the file you should open
is "/proc/self/fd/NUMBER" where NUMBER is the file descriptor
number you got from the environment variable. For the example
above, the pipe for myfile.a (environment variable A) is
"/proc/self/fd/3".</p>
<p>If you are using <span class="strong"><strong>pegasus-kickstart</strong></span>, which is probably the case
if you are using PMC for a Pegasus workflow, then there’s a trick
you can do to avoid modifying your code. You use the /proc file
system, as described above, but you let pegasus-kickstart handle
the path construction. For example, if your application has an
argument, -o, that allows you to specify the output file then
you can write your task like this:</p>
<pre class="screen">TASK mytask -f A=/tmp/myfile.a /bin/pegasus-kickstart /bin/mytask -o /proc/self/fd/$A</pre>
<p>In this case, pegasus-kickstart will replace the $A in your
application arguments with the file descriptor number you want.
Your code can open that path normally, write to it, and then close
it as if it were a regular file.</p>
</div>
<div class="refsect2" title="I/O forwarding using files">
<a name="pegasus-mpi-cluster_i_o_forwarding_using_files"></a><h3>I/O forwarding using files</h3>
<p>I/O forwarding with files works by having tasks write out data in files on
the local disk. The PMC worker process reads these files and forwards the
data to the master where it can be written to the desired output file.
This approach may be much less efficient than using pipes because it involves
the file system, which has more overhead than a pipe.</p>
<p>File forwarding can be enabled by giving the <span class="strong"><strong>-F/--file-forward</strong></span>
argument to a task.</p>
<p>Here’s an example:</p>
<pre class="screen">TASK mytask -F /tmp/foo.0=/scratch/foo /bin/mytask -o /tmp/foo.0</pre>
<p>In this case, the worker process will expect to find the file /tmp/foo.0
when mytask exits successfully. It reads the data from that file and sends
it to the master to be written to the end of /scratch/foo. After
/tmp/foo.0 is read it will be deleted by the worker process.</p>
<p>This approach works best on systems where the local disk is a RAM file
system such as Cray XT machines. Alternatively, the task can use /dev/shm
on a regular Linux cluster. It might also work relatively efficiently on a
local disk if the file system cache is able to absorb all of the reads and
writes.</p>
</div>
<div class="refsect2" title="I/O forwarding caveats">
<a name="pegasus-mpi-cluster_i_o_forwarding_caveats"></a><h3>I/O forwarding caveats</h3>
<p>When using I/O forwarding it is important to consider a few caveats.</p>
<p>First, if the PMC job fails for any reason (including when the workflow
is aborted for violating <span class="strong"><strong>--max-wall-time</strong></span>), then the files containing
forwarded I/O may be corrupted. They can include <span class="strong"><strong>partial records</strong></span>,
meaning that only part of the I/O from one or more tasks was written,
and they can include <span class="strong"><strong>duplicate records</strong></span>, meaning that the I/O was written,
but the PMC job failed before the task could be marked as successful,
and the workflow was restarted later. We make no guarantees about the
contents of the data files in this case. It is up to the code that
reads the files to a) detect and b) recover from such problems. To
eliminate duplicates the records should include a unique identifier,
and to eliminate partials the records should include a checksum.</p>
<p>Second, you should not use I/O forwarding if your task is going to
write a lot of data to the file. Because the PMC worker is reading
data off the pipe/file into memory and sending it in an MPI message,
if you write too much, then the worker process will run the system out
of memory. Also, all the data needs to fit in a single MPI message.
In pipe forwarding there is no hard limit on the size, but in file
forwarding the limit is 1MB. We haven’t benchmarked the performance
on large I/O, but anything larger than about 1 MB is probably too
much. At any rate, if your data is larger than 1MB, then I/O
forwarding probably won’t have much of a performance benefit anyway.</p>
<p>Third, the I/O is not written to the file if the task returns a non-zero
exitcode. We assume that if the task failed that you don’t want the data
it produced.</p>
<p>Fourth, the data from different tasks is not interleaved. All of the
data written by a given task will appear sequentially in the output file.
Note that you can still get partial records, however, if any data from
a task appears it will never be split among non-adjacent ranges in
the output file. If you have 3 tasks that write: "I am a task" you
can get:</p>
<pre class="screen">I am a taskI am a taskI am a task</pre>
<p>and:</p>
<pre class="screen">I am a taskI amI am a task</pre>
<p>but not:</p>
<pre class="screen">I am a taskI amI am a task a task</pre>
<p>Fifth, data from different tasks appears in arbitrary order in the output
file. It depends on what order the tasks were executed by PMC, which may
be arbitrary if there are no dependencies between the tasks. The data
that is written should contain enough information that you are able to
determine which task produced it if you require that. PMC does not add any
headers or trailers to the data.</p>
<p>Sixth, a task will only be marked as successful if all of its I/O was
successfully written. If the workflow completed successfully, then the
I/O is guaranteed to have been written.</p>
<p>Seventh, if the master is not able to write to the output file for any
reason (e.g. the master tries to write the I/O to the destination file,
but the write() call returns an error) then the task is marked as failed
even if the task produced a non-zero exitcode. In other words, you may
get a non-zero kickstart record even when PMC marks the task failed.</p>
<p>Eighth, the pipes are write-only. If you need to read and write data
from the file you should use file forwarding and not pipe forwarding.</p>
<p>Ninth, all files are opened by the master in append mode. This is so
that, if the workflow fails and has to be restarted, or if a task fails
and is retried, the data that was written previously is not lost. PMC
never truncates the files. This is one of the reasons why you can have
partial records and duplicate records in the output file.</p>
<p>Finally, in file forwarding the output file is removed when the task exits.
You cannot rely on the file to be there when the next task runs even if
you write it to a shared file system.</p>
</div>
</div>
<div class="refsect1" title="Misc">
<a name="pegasus-mpi-cluster_misc"></a><h2>Misc</h2>
<div class="refsect2" title="Resource Utilization">
<a name="pegasus-mpi-cluster_resource_utilization"></a><h3>Resource Utilization</h3>
<p>At the end of the workflow run, the master will report the resource
utilization of the job. This is done by adding up the total runtimes
of all the tasks executed (including failed tasks) and dividing by
the total wall time of the job times N, where N is both the total
number of processes including the master, and the total number of
workers. These two resource utilization values are provided so that
users can get an idea about how efficiently they are making use of
the resources they allocated. Low resource utilization values suggest
that the user should use fewer cores, and longer wall time, on future
runs, while high resource utilization values suggest that the user
could use more cores for future runs and get a shorter wall time.</p>
</div>
</div>
<div class="refsect1" title="Known Issues">
<a name="pegasus-mpi-cluster_known_issues"></a><h2>Known Issues</h2>
<div class="refsect2" title="fork() and exec()">
<a name="pegasus-mpi-cluster_fork_and_exec"></a><h3>fork() and exec()</h3>
<p>In order for the worker processes to start tasks on the compute
node the compute nodes must support the <span class="strong"><strong>fork()</strong></span> and <span class="strong"><strong>exec()</strong></span> system
calls. If your target machine runs a stripped-down OS on the
compute nodes that does not support these system calls, then
<span class="strong"><strong>pegasus-mpi-cluster</strong></span> will not work.</p>
</div>
<div class="refsect2" title="CPU Usage">
<a name="CPU_USAGE_ISSUE"></a><h3>CPU Usage</h3>
<p>Many MPI implementations are optimized so that message sends and
receives do busy waiting (i.e. they spin/poll on a message send or
receive instead of sleeping). The reasoning is that sleeping adds
overhead and, since many HPC systems use space sharing on dedicated
hardware, there are no other processes competing, so spinning
instead of sleeping can produce better performance. On those
implementations MPI processes will run at 100% CPU usage even when
they are just waiting for a message. This is a big problem for
multicore tasks in <span class="strong"><strong>pegasus-mpi-cluster</strong></span> because idle slots consume
CPU resources. In order to solve this problem <span class="strong"><strong>pegasus-mpi-cluster</strong></span>
processes sleep for a short period between checks for waiting
messages. This reduces the load significantly, but causes a short
delay in receiving messages. If you are using an MPI implementation
that sleeps on message send and receive instead of doing busy waiting,
then you can disable the sleep by specifying the <span class="strong"><strong>--no-sleep-on-recv</strong></span>
option. Note that the master will always sleep if <span class="strong"><strong>--max-wall-time</strong></span>
is specified because there is no way to interrupt or otherwise
timeout a blocking call in MPI (e.g. SIGALRM does not cause MPI_Recv
to return EINTR).</p>
</div>
</div>
<div class="refsect1" title="Environment Variables">
<a name="pegasus-mpi-cluster_environment_variables"></a><h2>Environment Variables</h2>
<p>The environment variables below are aliases for command-line options.
If the environment variable is present, then it is used as the default
for the associated option. If both are present, then the command-line
option is used.</p>
<div class="variablelist"><dl>
<dt><span class="term">
<span class="strong"><strong>PMC_HOST_SCRIPT</strong></span>
</span></dt>
<dd>
    Alias for the <span class="strong"><strong>--host-script</strong></span> option.
</dd>
<dt><span class="term">
<span class="strong"><strong>PMC_HOST_MEMORY</strong></span>
</span></dt>
<dd>
    Alias for the <span class="strong"><strong>--host-memory</strong></span> option.
</dd>
<dt><span class="term">
<span class="strong"><strong>PMC_HOST_CPUS</strong></span>
</span></dt>
<dd>
    Alias for the <span class="strong"><strong>--host-cpus</strong></span> option.
</dd>
<dt><span class="term">
<span class="strong"><strong>PMC_MAX_WALL_TIME</strong></span>
</span></dt>
<dd>
    Alias for the <span class="strong"><strong>--max-wall-time</strong></span> option.
</dd>
</dl></div>
</div>
<div class="refsect1" title="Author">
<a name="pegasus-mpi-cluster_author"></a><h2>Author</h2>
<p>Gideon Juve <code class="literal">&lt;gideon@isi.edu&gt;</code></p>
<p>Mats Rynge <code class="literal">&lt;rynge@isi.edu&gt;</code></p>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-monitord.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="reference.php#cli">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-plan.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-monitord </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-plan</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
