<?php  
            include_once( $_SERVER['DOCUMENT_ROOT']."/static/includes/common.inc.php" );
            do_html_header("Documentation");
        ?><div id="content">
<div class="navheader">
<table width="100%" summary="Navigation header"><tr>
<td width="20%" align="left">
<a accesskey="p" href="cli-pegasus-gridftp.php">Prev</a> </td>
<td width="60%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="20%" align="right"> <a accesskey="n" href="cli-pegasus-keg.php">Next</a>
</td>
</tr></table>
<hr>
</div>
<div lang="en" class="refentry" title="pegasus-invoke">
<a name="cli-pegasus-invoke"></a><div class="titlepage"></div>
<div class="refnamediv">
<h2>Name</h2>
<p>pegasus-invoke — invokes a command from a file</p>
</div>
<div class="refsynopsisdiv" title="Synopsis">
<a name="pegasus-invoke_synopsis"></a><h2>Synopsis</h2>
<div class="blockquote"><blockquote class="blockquote"><div class="literallayout"><p><span class="strong"><strong>pegasus-invoke</strong></span> ( <span class="strong"><strong>app</strong></span> | <span class="strong"><strong>@fn</strong></span> ) [ <span class="strong"><strong>arg | *@fn</strong></span> [..]]</p></div></blockquote></div>
</div>
<div class="refsect1" title="Description">
<a name="pegasus-invoke_description"></a><h2>Description</h2>
<p>The <span class="strong"><strong>pegasus-invoke</strong></span> tool invokes a single application with as many
arguments as your Unix permits (128k characters for Linux). Arguments
are come from two places, either the command-line as regular arguments,
or from a special file, which contains one argument per line.</p>
<p>The <span class="strong"><strong>pegasus-invoke</strong></span> tool became necessary to work around the 4k
argument length limit in Condor. It also permits to use arguments inside
argument files without worry about shell, Condor or Globus escape
necessities. All argument file contents are passed as is, one line per
argument entry.</p>
</div>
<div class="refsect1" title="Arguments">
<a name="pegasus-invoke_arguments"></a><h2>Arguments</h2>
<div class="variablelist"><dl>
<dt><span class="term">
<span class="strong"><strong>-d</strong></span>
</span></dt>
<dd>
This option increases the debug level. Currently, only debugging or
no debugging is distinguished. Debug message are generated on
<span class="emphasis"><em>stdout</em></span> . By default, debugging is disabled.
</dd>
<dt><span class="term">
<span class="strong"><strong>-h</strong></span>
</span></dt>
<dd>
This option prints the help message and exits the program.
</dd>
<dt><span class="term">
<span class="strong"><strong>--</strong></span>
</span></dt>
<dd>
This option stops any option processing. It may only be necessary,
if the application is stated on the command-line, and starts with a
hyphen itself.The first argument must either be the application to run
as fully-specified location (either absolute, or relative to current
wd), or a file containing one argument per line. The <span class="emphasis"><em>PATH</em></span> environment
variables is <span class="strong"><strong>not</strong></span> used to locate an application. Subsequent arguments
may either be specified explicitely on the commandline. Any argument
that starts with an at (@) sign is taken to introduce a filename,
which contains one argument per line. The textual file may contain
long arguments and filenames. However, Unices still impose limits on
the maximum length of a directory name, and the maximum length of a
file name. These lengths are not checked, because <span class="strong"><strong>pegasus-invoke</strong></span> is
oblivious of the application (e.g. what argument is a filename, and what
argument is a mere string resembling a filename).
</dd>
</dl></div>
</div>
<div class="refsect1" title="Return Value">
<a name="pegasus-invoke_return_value"></a><h2>Return Value</h2>
<p>The <span class="strong"><strong>pegasus-invoke</strong></span> tool returns 127, if it was unable to find the
application. It returns 126, if there was a problem parsing the file.
All other exit status, including 126 and 127, come from the application.</p>
</div>
<div class="refsect1" title="See Also">
<a name="pegasus-invoke_see_also"></a><h2>See Also</h2>
<p><span class="strong"><strong>pegasus-kickstart(1)</strong></span></p>
</div>
<div class="refsect1" title="Example">
<a name="pegasus-invoke_example"></a><h2>Example</h2>
<pre class="screen">$ echo "/bin/date" &gt; X
$ echo "-Isec" &gt;&gt; X
$ pegasus-invoke @X
2005-11-03T15:07:01-0600</pre>
<p>Recursion is also possible. Please mind not to use circular inclusions.
Also note how duplicating the initial at (@) sign will escape its
meaning as inclusion symbol.</p>
<pre class="screen">$ cat test.3
This is test 3

$ cat test.2
/bin/echo
@test.3
@@test.3

$ pegasus-invoke @test.2
This is test 3 @test.3</pre>
</div>
<div class="refsect1" title="Restrictions">
<a name="pegasus-invoke_restrictions"></a><h2>Restrictions</h2>
<p>While the arguments themselves may contain files with arguments to
parse, starting with an at (@) sign as before, the maximum recursion
limit is 32 levels of inclusions. It is not possible (yet) to use
<span class="emphasis"><em>stdin</em></span> as source of inclusion.</p>
</div>
<div class="refsect1" title="History">
<a name="pegasus-invoke_history"></a><h2>History</h2>
<p>As you may have noticed, <span class="strong"><strong>pegasus-invoke</strong></span> had the name <span class="strong"><strong>invoke</strong></span> in
previous incantations. We are slowly moving to the new name to avoid
clashes in a larger OS installation setting. However, there is no
pertinent need to change the internal name, too, as no name clashes are
expected.</p>
</div>
<div class="refsect1" title="Authors">
<a name="pegasus-invoke_authors"></a><h2>Authors</h2>
<p>Mike Wilde &lt;wilde at mcs dot anl dot gov&gt;</p>
<p>Jens-S. Vöckler &lt;voeckler at isi dot edu&gt;</p>
<p>Pegasus <span class="strong"><strong>http://pegasus.isi.edu/</strong></span></p>
</div>
</div>
<div class="navfooter">
<hr>
<table width="100%" summary="Navigation footer">
<tr>
<td width="40%" align="left">
<a accesskey="p" href="cli-pegasus-gridftp.php">Prev</a> </td>
<td width="20%" align="center"><a accesskey="u" href="reference.php#cli">Up</a></td>
<td width="40%" align="right"> <a accesskey="n" href="cli-pegasus-keg.php">Next</a>
</td>
</tr>
<tr>
<td width="40%" align="left" valign="top">pegasus-gridftp </td>
<td width="20%" align="center"><a accesskey="h" href="index.php">Table of Contents</a></td>
<td width="40%" align="right" valign="top"> pegasus-keg</td>
</tr>
</table>
</div>
</div><?php  
            do_html_footer();
        ?>
